// To parse this JSON data, do
//
//     final newTaxResponseModel = newTaxResponseModelFromJson(jsonString);

import 'dart:convert';

NewTaxResponseModel newTaxResponseModelFromJson(String str) =>
    NewTaxResponseModel.fromJson(json.decode(str));

String newTaxResponseModelToJson(NewTaxResponseModel data) =>
    json.encode(data.toJson());

class NewTaxResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  NewTaxResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory NewTaxResponseModel.fromJson(Map<String, dynamic> json) =>
      NewTaxResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Tax? tax;

  Data({
    this.tax,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        tax: json["tax"] == null ? null : Tax.fromJson(json["tax"]),
      );

  Map<String, dynamic> toJson() => {
        "tax": tax?.toJson(),
      };
}

class Tax {
  String? name;
  String? percentage;
  String? updatedAt;
  String? createdAt;
  String? id;

  Tax({
    this.name,
    this.percentage,
    this.updatedAt,
    this.createdAt,
    this.id,
  });

  factory Tax.fromJson(Map<String, dynamic> json) => Tax(
        name: json["name"].toString(),
        percentage: json["percentage"].toString(),
        updatedAt: json["updated_at"].toString(),
        createdAt: json["created_at"].toString(),
        id: json["id"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "percentage": percentage,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
      };
}
