// To parse this JSON data, do
//
//     final supplierStatusChangeResponseModel = supplierStatusChangeResponseModelFromJson(jsonString);

import 'dart:convert';

SupplierStatusChangeResponseModel supplierStatusChangeResponseModelFromJson(
        String str) =>
    SupplierStatusChangeResponseModel.fromJson(json.decode(str));

String supplierStatusChangeResponseModelToJson(
        SupplierStatusChangeResponseModel data) =>
    json.encode(data.toJson());

class SupplierStatusChangeResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  SupplierStatusChangeResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory SupplierStatusChangeResponseModel.fromJson(
          Map<String, dynamic> json) =>
      SupplierStatusChangeResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Supplier? supplier;

  Data({
    this.supplier,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        supplier: json["supplier"] == null
            ? null
            : Supplier.fromJson(json["supplier"]),
      );

  Map<String, dynamic> toJson() => {
        "supplier": supplier?.toJson(),
      };
}

class Supplier {
  String? id;
  String? name;
  String? email;
  String? mobile;
  String? companyName;
  String? address;
  String? city;
  String? state;
  String? country;
  String? zip;
  String? postcode;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  Supplier({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.companyName,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Supplier.fromJson(Map<String, dynamic> json) => Supplier(
        id: json["id"].toString(),
        name: json["name"].toString(),
        email: json["email"].toString(),
        mobile: json["mobile"].toString(),
        companyName: json["company_name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        country: json["country"].toString(),
        zip: json["zip"].toString(),
        postcode: json["postcode"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "email": email,
        "mobile": mobile,
        "company_name": companyName,
        "address": address,
        "city": city,
        "state": state,
        "country": country,
        "zip": zip,
        "postcode": postcode,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
