// To parse this JSON data, do
//
//     final saleListResponseModel = saleListResponseModelFromJson(jsonString);

import 'dart:convert';

import '../new_sale/required_data_response_model.dart';

SaleListResponseModel saleListResponseModelFromJson(String str) =>
    SaleListResponseModel.fromJson(json.decode(str));

class SaleListResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  SaleListResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory SaleListResponseModel.fromJson(Map<String, dynamic> json) =>
      SaleListResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  Sales? sales;
  Widget? widget;

  Data({
    this.sales,
    this.widget,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        sales: json["sales"] == null ? null : Sales.fromJson(json["sales"]),
        widget: json["widget"] == null ? null : Widget.fromJson(json["widget"]),
      );
}

class Sales {
  List<SalesList>? data;
  String? nextPageUrl;

  Sales({
    this.data,
    this.nextPageUrl,
  });

  factory Sales.fromJson(Map<String, dynamic> json) => Sales(
        data: json["data"] == null
            ? []
            : List<SalesList>.from(
                json["data"]!.map((x) => SalesList.fromJson(x))),
        nextPageUrl: json["next_page_url"],
      );
}

class SalesList {
  int? id;
  String? invoiceNumber;
  String? saleDate;
  int? customerId;
  int? warehouseId;
  int? discountType;
  String? discountValue;
  String? discountAmount;
  String? shippingAmount;
  String? subtotal;
  String? total;
  String? payingAmount;
  String? changesAmount;
  String? note;
  int? adminId;
  int? isPosSale;
  String? status;
  int? couponId;
  dynamic deletedAt;
  String? createdAt;
  String? updatedAt;
  int? saleDetailsCount;
  String? paymentsSumAmount;
  Warehouse? warehouse;
  Customer? customer;
  List<Payment>? payments;
  bool isLoading;

  SalesList(
      {this.id,
      this.invoiceNumber,
      this.saleDate,
      this.customerId,
      this.warehouseId,
      this.discountType,
      this.discountValue,
      this.discountAmount,
      this.shippingAmount,
      this.subtotal,
      this.total,
      this.payingAmount,
      this.changesAmount,
      this.note,
      this.adminId,
      this.isPosSale,
      this.status,
      this.couponId,
      this.deletedAt,
      this.createdAt,
      this.updatedAt,
      this.saleDetailsCount,
      this.paymentsSumAmount,
      this.warehouse,
      this.customer,
      this.payments,
      this.isLoading = false});

  factory SalesList.fromJson(Map<String, dynamic> json) => SalesList(
        id: json["id"],
        invoiceNumber: json["invoice_number"],
        saleDate: json["sale_date"]?.toString(),
        customerId: json["customer_id"],
        warehouseId: json["warehouse_id"],
        discountType: json["discount_type"],
        discountValue: json["discount_value"],
        discountAmount: json["discount_amount"],
        shippingAmount: json["shipping_amount"],
        subtotal: json["subtotal"],
        total: json["total"],
        payingAmount: json["paying_amount"],
        changesAmount: json["changes_amount"],
        note: json["note"],
        adminId: json["admin_id"],
        isPosSale: json["is_pos_sale"],
        status: json["status"]?.toString(),
        couponId: json["coupon_id"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        saleDetailsCount: json["sale_details_count"],
        paymentsSumAmount: json["payments_sum_amount"],
        warehouse: json["warehouse"] == null
            ? null
            : Warehouse.fromJson(json["warehouse"]),
        customer: json["customer"] == null
            ? null
            : Customer.fromJson(json["customer"]),
        payments: json["payments"] == null
            ? []
            : List<Payment>.from(
                json["payments"]!.map((x) => Payment.fromJson(x))),
      );
}

class Customer {
  int? id;
  String? name;
  String? email;
  String? mobile;
  String? address;
  String? city;
  String? state;
  String? country;
  String? zip;
  String? postcode;
  int? status;
  dynamic deletedAt;
  String? createdAt;
  String? updatedAt;

  Customer({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Customer.fromJson(Map<String, dynamic> json) => Customer(
        id: json["id"],
        name: json["name"],
        email: json["email"],
        mobile: json["mobile"],
        address: json["address"],
        city: json["city"],
        state: json["state"],
        country: json["country"],
        zip: json["zip"],
        postcode: json["postcode"],
        status: json["status"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );
}

class Payment {
  int? id;
  int? saleId;
  int? customerId;
  PaymentType? paymentType;
  String? amount;
  String? note;
  DateTime? date;
  String? createdAt;
  String? updatedAt;

  Payment({
    this.id,
    this.saleId,
    this.customerId,
    this.paymentType,
    this.amount,
    this.note,
    this.date,
    this.createdAt,
    this.updatedAt,
  });

  factory Payment.fromJson(Map<String, dynamic> json) => Payment(
        id: json["id"],
        saleId: json["sale_id"],
        customerId: json["customer_id"],
        paymentType: json["payment_type"] == null
            ? null
            : PaymentType.fromJson(json["payment_type"]),
        amount: json["amount"],
        note: json["note"],
        date: json["date"] == null ? null : DateTime.parse(json["date"]),
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );
}

class PaymentType {
  int? id;
  String? name;
  int? status;
  int? isDefault;
  dynamic deletedAt;
  String? createdAt;
  String? updatedAt;

  PaymentType({
    this.id,
    this.name,
    this.status,
    this.isDefault,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory PaymentType.fromJson(Map<String, dynamic> json) => PaymentType(
        id: json["id"],
        name: json["name"],
        status: json["status"],
        isDefault: json["is_default"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );
}

class Widget {
  String? todaySale;
  String? yesterdaySale;
  String? thisWeekSale;
  String? thisMonthSale;
  String? last7DaysWeekSale;
  String? last30DaysMonthSale;
  String? allSale;
  String? lastSaleAmount;

  Widget({
    this.todaySale,
    this.yesterdaySale,
    this.thisWeekSale,
    this.thisMonthSale,
    this.last7DaysWeekSale,
    this.last30DaysMonthSale,
    this.allSale,
    this.lastSaleAmount,
  });

  factory Widget.fromJson(Map<String, dynamic> json) => Widget(
        todaySale: json["today_sale"]?.toString(),
        yesterdaySale: json["yesterday_sale"]?.toString(),
        thisWeekSale: json["this_week_sale"]?.toString(),
        thisMonthSale: json["this_month_sale"]?.toString(),
        last7DaysWeekSale: json["last_7days_week_sale"]?.toString(),
        last30DaysMonthSale: json["last_30days_month_sale"]?.toString(),
        allSale: json["all_sale"]?.toString(),
        lastSaleAmount: json["last_sale_amount"]?.toString(),
      );
}
