// To parse this JSON data, do
//
//     final roleandPermissionUpdateResponseModel = roleandPermissionUpdateResponseModelFromJson(jsonString);

import 'dart:convert';

RoleandPermissionUpdateResponseModel
    roleandPermissionUpdateResponseModelFromJson(String str) =>
        RoleandPermissionUpdateResponseModel.fromJson(json.decode(str));

String roleandPermissionUpdateResponseModelToJson(
        RoleandPermissionUpdateResponseModel data) =>
    json.encode(data.toJson());

class RoleandPermissionUpdateResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  RoleandPermissionUpdateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory RoleandPermissionUpdateResponseModel.fromJson(
          Map<String, dynamic> json) =>
      RoleandPermissionUpdateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Role? role;

  Data({
    this.role,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        role: json["role"] == null ? null : Role.fromJson(json["role"]),
      );

  Map<String, dynamic> toJson() => {
        "role": role?.toJson(),
      };
}

class Role {
  final String? id;
  final String? name;
  final String? guardName;
  final String? status;
  final String? createdAt;
  final String? updatedAt;

  Role({
    this.id,
    this.name,
    this.guardName,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory Role.fromJson(Map<String, dynamic> json) => Role(
        id: json["id"].toString(),
        name: json["name"].toString(),
        guardName: json["guard_name"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "guard_name": guardName,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
