import 'dart:convert';

import 'new_role_and_permission_model.dart';

RoleandPermissionResponseModel roleandPermissionResponseModelFromJson(
        String str) =>
    RoleandPermissionResponseModel.fromJson(json.decode(str));

String roleandPermissionResponseModelToJson(
        RoleandPermissionResponseModel data) =>
    json.encode(data.toJson());

class RoleandPermissionResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  RoleandPermissionResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory RoleandPermissionResponseModel.fromJson(Map<String, dynamic> json) =>
      RoleandPermissionResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final List<Role>? roles;

  Data({
    this.roles,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        roles: json["roles"] == null
            ? []
            : List<Role>.from(json["roles"]!.map((x) => Role.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "roles": roles == null
            ? []
            : List<dynamic>.from(roles!.map((x) => x.toJson())),
      };
}

class Role {
  String? id;
  String? name;
  String? guardName;
  String? status;
  String? createdAt;
  String? updatedAt;
  final List<Permission>? permissions;

  Role({
    this.id,
    this.name,
    this.guardName,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.permissions,
  });

  factory Role.fromJson(Map<String, dynamic> json) => Role(
        id: json["id"].toString(),
        name: json["name"].toString(),
        guardName: json["guard_name"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        permissions: json["permissions"] == null
            ? []
            : List<Permission>.from(
                json["permissions"]!.map((x) => Permission.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "guard_name": guardName,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
