// To parse this JSON data, do
//
//     final roleandPermissionResponseModel = roleandPermissionResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:ovosale/data/model/role_and_permission/role_and_permission_response_model.dart';

NewRoleandPermissionResponseModel newRoleandPermissionResponseModelFromJson(
        String str) =>
    NewRoleandPermissionResponseModel.fromJson(json.decode(str));

String roleandPermissionResponseModelToJson(
        NewRoleandPermissionResponseModel data) =>
    json.encode(data.toJson());

class NewRoleandPermissionResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  NewRoleandPermissionResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory NewRoleandPermissionResponseModel.fromJson(
          Map<String, dynamic> json) =>
      NewRoleandPermissionResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Role? role;
  final List<Permission>? permissions;
  final List<Permission>? existingPermissions;

  Data({
    this.role,
    this.permissions,
    this.existingPermissions,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        role: json["role"] == null ? null : Role.fromJson(json["role"]),
        permissions: json["permissions"] == null
            ? []
            : List<Permission>.from(
                json["permissions"]!.map((x) => Permission.fromJson(x))),
        existingPermissions: json["existingPermissions"] == null
            ? []
            : List<Permission>.from(json["existingPermissions"]!
                .map((x) => Permission.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "role": role?.toJson(),
        "permissions": permissions == null
            ? []
            : List<dynamic>.from(permissions!.map((x) => x.toJson())),
        "existingPermissions": existingPermissions == null
            ? []
            : List<dynamic>.from(existingPermissions!.map((x) => x.toJson())),
      };
}

class Permission {
  final String? id;
  final String? name;
  final String? guardName;
  final String? groupName;
  final String? createdAt;
  final String? updatedAt;
  final Pivot? pivot;

  Permission({
    this.id,
    this.name,
    this.guardName,
    this.groupName,
    this.createdAt,
    this.updatedAt,
    this.pivot,
  });

  factory Permission.fromJson(Map<String, dynamic> json) => Permission(
        id: json["id"].toString(),
        name: json["name"].toString(),
        guardName: json["guard_name"].toString(),
        groupName: json["group_name"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        pivot: json["pivot"] == null ? null : Pivot.fromJson(json["pivot"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "guard_name": guardName,
        "group_name": groupName,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "pivot": pivot?.toJson(),
      };
}

class Pivot {
  final String? roleId;
  final String? permissionId;

  Pivot({
    this.roleId,
    this.permissionId,
  });

  factory Pivot.fromJson(Map<String, dynamic> json) => Pivot(
        roleId: json["role_id"].toString(),
        permissionId: json["permission_id"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "role_id": roleId,
        "permission_id": permissionId,
      };
}
/*
class Role {
  final String? id;
  final String? name;
  final String? guardName;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final List<Permission>? permissions;

  Role({
    this.id,
    this.name,
    this.guardName,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.permissions,
  });

  factory Role.fromJson(Map<String, dynamic> json) => Role(
        id: json["id"].toString(),
        name: json["name"].toString(),
        guardName: json["guard_name"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        permissions: json["permissions"] == null
            ? []
            : List<Permission>.from(
                json["permissions"]!.map((x) => Permission.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "guard_name": guardName,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "permissions": permissions == null
            ? []
            : List<dynamic>.from(permissions!.map((x) => x.toJson())),
      };
}*/
