import 'dart:convert';

import '../new_sale/required_data_response_model.dart';
import '../product/update_product_data_response_model.dart';

StockReportResponseModel stockReportResponseModelFromJson(String str) =>
    StockReportResponseModel.fromJson(json.decode(str));

class StockReportResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  StockReportResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory StockReportResponseModel.fromJson(Map<String, dynamic> json) =>
      StockReportResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  Products? products;
  List<Warehouse>? warehouses;
  Warehouse? selectWarehouse;

  Data({
    this.products,
    this.warehouses,
    this.selectWarehouse,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        products: json["products"] == null
            ? null
            : Products.fromJson(json["products"]),
        warehouses: json["warehouses"] == null
            ? []
            : List<Warehouse>.from(
                json["warehouses"]!.map((x) => Warehouse.fromJson(x))),
        selectWarehouse: json["selectWarehouse"] == null
            ? null
            : Warehouse.fromJson(json["selectWarehouse"]),
      );
}

class Brand {
  int? id;
  String? name;
  int? status;
  String? image;
  String? createdAt;
  String? updatedAt;
  dynamic deletedAt;
  String? imageSrc;
  String? shortName;

  Brand({
    this.id,
    this.name,
    this.status,
    this.image,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
    this.imageSrc,
    this.shortName,
  });

  factory Brand.fromJson(Map<String, dynamic> json) => Brand(
        id: json["id"],
        name: json["name"],
        status: json["status"],
        image: json["image"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        deletedAt: json["deleted_at"],
        imageSrc: json["image_src"],
        shortName: json["short_name"],
      );
}

class Products {
  String? nextPageUrl;
  List<Stock>? data;
  Products({this.nextPageUrl, this.data});

  factory Products.fromJson(Map<String, dynamic> json) => Products(
        nextPageUrl: json["next_page_url"].toString(),
        data: json["data"] == null
            ? []
            : List<Stock>.from(json["data"]!.map((x) => Stock.fromJson(x))),
      );
}

class Stock {
  int? id;
  int? productId;
  String? sku;
  String? basePrice;
  int? taxId;
  int? taxType;
  String? taxAmount;
  String? taxPercentage;
  String? purchasePrice;
  String? profitMargin;
  String? salePrice;
  int? discountType;
  String? discountValue;
  String? discountAmount;
  String? finalPrice;
  String? alertQuantity;
  int? variantId;
  int? attributeId;
  dynamic createdAt;
  String? updatedAt;
  String? productStockSumStock;
  Product? product;
  List<ProductStock>? productStock;

  Stock({
    this.id,
    this.productId,
    this.sku,
    this.basePrice,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.purchasePrice,
    this.profitMargin,
    this.salePrice,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.finalPrice,
    this.alertQuantity,
    this.variantId,
    this.attributeId,
    this.createdAt,
    this.updatedAt,
    this.productStockSumStock,
    this.product,
    this.productStock,
  });

  factory Stock.fromJson(Map<String, dynamic> json) => Stock(
        id: json["id"],
        productId: json["product_id"],
        sku: json["sku"],
        basePrice: json["base_price"],
        taxId: json["tax_id"],
        taxType: json["tax_type"],
        taxAmount: json["tax_amount"],
        taxPercentage: json["tax_percentage"],
        purchasePrice: json["purchase_price"],
        profitMargin: json["profit_margin"],
        salePrice: json["sale_price"],
        discountType: json["discount_type"],
        discountValue: json["discount_value"],
        discountAmount: json["discount_amount"],
        finalPrice: json["final_price"],
        alertQuantity: json["alert_quantity"],
        variantId: json["variant_id"],
        attributeId: json["attribute_id"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        productStockSumStock: json["product_stock_sum_stock"],
        product:
            json["product"] == null ? null : Product.fromJson(json["product"]),
        productStock: json["product_stock"] == null
            ? []
            : List<ProductStock>.from(
                json["product_stock"]!.map((x) => ProductStock.fromJson(x))),
      );
}

class ProductStock {
  int? id;
  int? productId;
  int? productDetailsId;
  int? warehouseId;
  int? stock;
  String? createdAt;
  String? updatedAt;
  Warehouse? warehouse;

  ProductStock({
    this.id,
    this.productId,
    this.productDetailsId,
    this.warehouseId,
    this.stock,
    this.createdAt,
    this.updatedAt,
    this.warehouse,
  });

  factory ProductStock.fromJson(Map<String, dynamic> json) => ProductStock(
        id: json["id"],
        productId: json["product_id"],
        productDetailsId: json["product_details_id"],
        warehouseId: json["warehouse_id"],
        stock: json["stock"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        warehouse: json["warehouse"] == null
            ? null
            : Warehouse.fromJson(json["warehouse"]),
      );
}
