// To parse this JSON data, do
//
//     final salesReportResponseModel = salesReportResponseModelFromJson(jsonString);

import 'dart:convert';

SalesReportResponseModel salesReportResponseModelFromJson(String str) =>
    SalesReportResponseModel.fromJson(json.decode(str));

class SalesReportResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  SalesReportResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory SalesReportResponseModel.fromJson(Map<String, dynamic> json) =>
      SalesReportResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  Sales? sales;

  Data({
    this.sales,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        sales: json["sales"] == null ? null : Sales.fromJson(json["sales"]),
      );
}

class Sales {
  List<SalesReport>? data;
  String? nextPageUrl;

  Sales({
    this.data,
    this.nextPageUrl,
  });

  factory Sales.fromJson(Map<String, dynamic> json) => Sales(
        data: json["data"] == null
            ? []
            : List<SalesReport>.from(
                json["data"]!.map((x) => SalesReport.fromJson(x))),
        nextPageUrl: json["next_page_url"],
      );
}

class SalesReport {
  int? id;
  String? invoiceNumber;
  String? saleDate;
  int? customerId;
  int? warehouseId;
  int? discountType;
  String? discountValue;
  String? discountAmount;
  String? shippingAmount;
  String? subtotal;
  String? total;
  String? payingAmount;
  String? changesAmount;
  dynamic note;
  int? adminId;
  int? isPosSale;
  int? status;
  int? couponId;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;
  String? paymentsSumAmount;
  String? totalPurchaseValue;
  String? saleDetailsCount;
  Customer? customer;

  SalesReport(
      {this.id,
      this.invoiceNumber,
      this.saleDate,
      this.customerId,
      this.warehouseId,
      this.discountType,
      this.discountValue,
      this.discountAmount,
      this.shippingAmount,
      this.subtotal,
      this.total,
      this.payingAmount,
      this.changesAmount,
      this.note,
      this.adminId,
      this.isPosSale,
      this.status,
      this.couponId,
      this.deletedAt,
      this.createdAt,
      this.updatedAt,
      this.paymentsSumAmount,
      this.saleDetailsCount,
      this.customer,
      this.totalPurchaseValue});

  factory SalesReport.fromJson(Map<String, dynamic> json) => SalesReport(
        id: json["id"],
        invoiceNumber: json["invoice_number"],
        saleDate: json["sale_date"] != null ? json["sale_date"].toString() : "",
        customerId: json["customer_id"],
        warehouseId: json["warehouse_id"],
        discountType: json["discount_type"],
        discountValue: json["discount_value"],
        discountAmount: json["discount_amount"],
        shippingAmount: json["shipping_amount"],
        subtotal: json["subtotal"],
        total: json["total"] != null ? json["total"].toString() : "0.00",
        payingAmount: json["paying_amount"],
        changesAmount: json["changes_amount"],
        note: json["note"],
        adminId: json["admin_id"],
        isPosSale: json["is_pos_sale"],
        status: json["status"],
        couponId: json["coupon_id"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        paymentsSumAmount: json["payments_sum_amount"],
        totalPurchaseValue: json["total_purchase_value"] != null
            ? json["total_purchase_value"].toString()
            : "0.00",
        saleDetailsCount: json["sale_details_count"].toString(),
        customer: json["customer"] == null
            ? null
            : Customer.fromJson(json["customer"]),
      );
}

class Customer {
  int? id;
  String? name;
  String? email;
  String? mobile;
  String? address;
  String? city;
  String? state;
  String? country;
  String? zip;
  String? postcode;
  int? status;
  dynamic deletedAt;
  String? createdAt;
  String? updatedAt;

  Customer({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Customer.fromJson(Map<String, dynamic> json) => Customer(
        id: json["id"],
        name: json["name"] != null ? json["name"].toString() : "",
        email: json["email"],
        mobile: json["mobile"],
        address: json["address"],
        city: json["city"],
        state: json["state"],
        country: json["country"],
        zip: json["zip"],
        postcode: json["postcode"],
        status: json["status"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );
}
