// To parse this JSON data, do
//
//     final purchaseReportResponseModel = purchaseReportResponseModelFromJson(jsonString);

import 'dart:convert';

PurchaseReportResponseModel purchaseReportResponseModelFromJson(String str) =>
    PurchaseReportResponseModel.fromJson(json.decode(str));

class PurchaseReportResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  PurchaseReportResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory PurchaseReportResponseModel.fromJson(Map<String, dynamic> json) =>
      PurchaseReportResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  Purchases? purchases;

  Data({
    this.purchases,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        purchases: json["purchases"] == null
            ? null
            : Purchases.fromJson(json["purchases"]),
      );
}

class Purchases {
  List<Purchase>? data;
  dynamic nextPageUrl;

  Purchases({
    this.data,
    this.nextPageUrl,
  });

  factory Purchases.fromJson(Map<String, dynamic> json) => Purchases(
        data: json["data"] == null
            ? []
            : List<Purchase>.from(
                json["data"]!.map((x) => Purchase.fromJson(x))),
        nextPageUrl: json["next_page_url"],
      );
}

class Purchase {
  int? id;
  String? invoiceNumber;
  String? referenceNumber;
  String? purchaseDate;
  int? supplierId;
  int? warehouseId;
  int? discountType;
  String? discountValue;
  String? discountAmount;
  String? shippingAmount;
  String? subtotal;
  String? total;
  String? attachment;
  String? status;
  int? adminId;
  dynamic deletedAt;
  String? createdAt;
  String? updatedAt;
  String? supplierPaymentsSumAmount;
  Supplier? supplier;

  Purchase({
    this.id,
    this.invoiceNumber,
    this.referenceNumber,
    this.purchaseDate,
    this.supplierId,
    this.warehouseId,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.shippingAmount,
    this.subtotal,
    this.total,
    this.attachment,
    this.status,
    this.adminId,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.supplierPaymentsSumAmount,
    this.supplier,
  });

  factory Purchase.fromJson(Map<String, dynamic> json) => Purchase(
        id: json["id"],
        invoiceNumber: json["invoice_number"],
        referenceNumber: json["reference_number"] != null
            ? json["reference_number"].toString()
            : "N/A",
        purchaseDate: json["purchase_date"] != null
            ? json["purchase_date"].toString()
            : "",
        supplierId: json["supplier_id"],
        warehouseId: json["warehouse_id"],
        discountType: json["discount_type"],
        discountValue: json["discount_value"],
        discountAmount: json["discount_amount"],
        shippingAmount: json["shipping_amount"],
        subtotal: json["subtotal"],
        total: json["total"] != null ? json["total"].toString() : "",
        attachment: json["attachment"],
        status: json["status"].toString(),
        adminId: json["admin_id"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        supplierPaymentsSumAmount:
            json["supplier_payments_sum_amount"].toString(),
        supplier: json["supplier"] == null
            ? null
            : Supplier.fromJson(json["supplier"]),
      );
}

class Supplier {
  int? id;
  String? name;
  dynamic email;
  String? mobile;
  String? companyName;
  dynamic address;
  dynamic city;
  String? state;
  dynamic country;
  dynamic zip;
  dynamic postcode;
  int? status;
  dynamic deletedAt;
  String? createdAt;
  String? updatedAt;

  Supplier({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.companyName,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Supplier.fromJson(Map<String, dynamic> json) => Supplier(
        id: json["id"],
        name: json["name"].toString(),
        email: json["email"],
        mobile: json["mobile"],
        companyName: json["company_name"],
        address: json["address"],
        city: json["city"],
        state: json["state"],
        country: json["country"],
        zip: json["zip"],
        postcode: json["postcode"],
        status: json["status"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );
}
