// To parse this JSON data, do
//
//     final profitLoassReportResponseModel = profitLoassReportResponseModelFromJson(jsonString);

import 'dart:convert';

ProfitLossReportResponseModel profitLossReportResponseModelFromJson(
        String str) =>
    ProfitLossReportResponseModel.fromJson(json.decode(str));

class ProfitLossReportResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  ProfitLossReportResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ProfitLossReportResponseModel.fromJson(Map<String, dynamic> json) =>
      ProfitLossReportResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  InvoicesWise? invoicesWise;
  Widget? widget;

  Data({
    this.invoicesWise,
    this.widget,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        invoicesWise: json["invoicesWise"] == null
            ? null
            : InvoicesWise.fromJson(json["invoicesWise"]),
        widget: json["widget"] == null ? null : Widget.fromJson(json["widget"]),
      );
}

class InvoicesWise {
  List<ProfitLoss>? data;
  String? nextPageUrl;

  InvoicesWise({
    this.data,
    this.nextPageUrl,
  });

  factory InvoicesWise.fromJson(Map<String, dynamic> json) => InvoicesWise(
        data: json["data"] == null
            ? []
            : List<ProfitLoss>.from(
                json["data"]!.map((x) => ProfitLoss.fromJson(x))),
        nextPageUrl: json["next_page_url"],
      );
}

class ProfitLoss {
  int? id;
  String? invoiceNumber;
  String? saleDate;
  int? customerId;
  int? warehouseId;
  int? discountType;
  String? discountValue;
  String? discountAmount;
  String? shippingAmount;
  String? subtotal;
  String? total;
  String? payingAmount;
  String? changesAmount;
  dynamic note;
  int? adminId;
  int? isPosSale;
  int? status;
  int? couponId;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;
  String? totalSalesPrice;
  String? totalPurchasePrice;
  String? grossProfit;
  Customer? customer;

  ProfitLoss({
    this.id,
    this.invoiceNumber,
    this.saleDate,
    this.customerId,
    this.warehouseId,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.shippingAmount,
    this.subtotal,
    this.total,
    this.payingAmount,
    this.changesAmount,
    this.note,
    this.adminId,
    this.isPosSale,
    this.status,
    this.couponId,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.totalSalesPrice,
    this.totalPurchasePrice,
    this.grossProfit,
    this.customer,
  });

  factory ProfitLoss.fromJson(Map<String, dynamic> json) => ProfitLoss(
        id: json["id"],
        invoiceNumber: json["invoice_number"],
        saleDate: json["sale_date"] != null ? json["sale_date"].toString() : "",
        customerId: json["customer_id"],
        warehouseId: json["warehouse_id"],
        discountType: json["discount_type"],
        discountValue: json["discount_value"],
        discountAmount: json["discount_amount"],
        shippingAmount: json["shipping_amount"],
        subtotal: json["subtotal"],
        total: json["total"],
        payingAmount: json["paying_amount"],
        changesAmount: json["changes_amount"],
        note: json["note"],
        adminId: json["admin_id"],
        isPosSale: json["is_pos_sale"],
        status: json["status"],
        couponId: json["coupon_id"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        totalSalesPrice: json["total_sales_price"],
        totalPurchasePrice: json["total_purchase_price"],
        grossProfit: json["gross_profit"],
        customer: json["customer"] == null
            ? null
            : Customer.fromJson(json["customer"]),
      );
}

class Customer {
  int? id;
  String? name;
  String? email;
  String? mobile;
  String? address;
  String? city;
  String? state;
  String? country;
  String? zip;
  String? postcode;
  int? status;
  dynamic deletedAt;
  String? createdAt;
  String? updatedAt;

  Customer({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Customer.fromJson(Map<String, dynamic> json) => Customer(
        id: json["id"],
        name: json["name"],
        email: json["email"],
        mobile: json["mobile"],
        address: json["address"],
        city: json["city"],
        state: json["state"],
        country: json["country"],
        zip: json["zip"],
        postcode: json["postcode"],
        status: json["status"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );
}

class Widget {
  int? totalInvoices;
  double? totalSale;
  int? totalPurchase;
  double? grossProfit;

  Widget({
    this.totalInvoices,
    this.totalSale,
    this.totalPurchase,
    this.grossProfit,
  });

  factory Widget.fromJson(Map<String, dynamic> json) => Widget(
        totalInvoices: json["total_invoices"],
        totalSale: json["total_sale"]?.toDouble(),
        totalPurchase: json["total_purchase"],
        grossProfit: json["gross_profit"]?.toDouble(),
      );
}
