// To parse this JSON data, do
//
//     final expenseReportResponseModel = expenseReportResponseModelFromJson(jsonString);

import 'dart:convert';

ExpenseReportResponseModel expenseReportResponseModelFromJson(String str) =>
    ExpenseReportResponseModel.fromJson(json.decode(str));

class ExpenseReportResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  ExpenseReportResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ExpenseReportResponseModel.fromJson(Map<String, dynamic> json) =>
      ExpenseReportResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  Expenses? expenses;

  Data({
    this.expenses,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        expenses: json["expenses"] == null
            ? null
            : Expenses.fromJson(json["expenses"]),
      );
}

class Expenses {
  List<Expense>? data;
  dynamic nextPageUrl;

  Expenses({
    this.data,
    this.nextPageUrl,
  });

  factory Expenses.fromJson(Map<String, dynamic> json) => Expenses(
        data: json["data"] == null
            ? []
            : List<Expense>.from(json["data"]!.map((x) => Expense.fromJson(x))),
        nextPageUrl: json["next_page_url"],
      );
}

class Expense {
  int? id;
  int? categoryId;
  int? addedBy;
  String? expenseDate;
  String? referenceNo;
  String? comment;
  String? amount;
  String? attachment;
  dynamic deletedAt;
  String? createdAt;
  String? updatedAt;
  Category? category;
  Admin? admin;

  Expense(
      {this.id,
      this.categoryId,
      this.addedBy,
      this.expenseDate,
      this.referenceNo,
      this.comment,
      this.amount,
      this.attachment,
      this.deletedAt,
      this.createdAt,
      this.updatedAt,
      this.category,
      this.admin});

  factory Expense.fromJson(Map<String, dynamic> json) => Expense(
        id: json["id"],
        categoryId: json["category_id"],
        addedBy: json["added_by"],
        expenseDate:
            json["expense_date"] != null ? json["expense_date"].toString() : "",
        referenceNo: json["reference_no"],
        comment: json["comment"],
        amount: json["amount"].toString(),
        attachment: json["attachment"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        category: json["category"] == null
            ? null
            : Category.fromJson(json["category"]),
        admin: json["admin"] == null ? null : Admin.fromJson(json["admin"]),
      );
}

class Category {
  int? id;
  String? name;
  int? status;
  String? createdAt;
  String? updatedAt;
  dynamic deletedAt;

  Category({
    this.id,
    this.name,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
  });

  factory Category.fromJson(Map<String, dynamic> json) => Category(
        id: json["id"],
        name: json["name"].toString(),
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        deletedAt: json["deleted_at"],
      );
}

class Admin {
  int? id;
  String? name;

  Admin({
    this.id,
    this.name,
  });

  factory Admin.fromJson(Map<String, dynamic> json) => Admin(
        id: json["id"],
        name: json["name"],
      );
}
