// To parse this JSON data, do
//
//     final purchaseDataResponseModel = purchaseDataResponseModelFromJson(jsonString);

import 'dart:convert';

PurchaseDataResponseModel purchaseDataResponseModelFromJson(String str) =>
    PurchaseDataResponseModel.fromJson(json.decode(str));

String purchaseDataResponseModelToJson(PurchaseDataResponseModel data) =>
    json.encode(data.toJson());

class PurchaseDataResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  PurchaseDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory PurchaseDataResponseModel.fromJson(Map<String, dynamic> json) =>
      PurchaseDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Purchases? purchases;
  final Widget? widget;

  Data({
    this.purchases,
    this.widget,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        purchases: json["purchases"] == null
            ? null
            : Purchases.fromJson(json["purchases"]),
        widget: json["widget"] == null ? null : Widget.fromJson(json["widget"]),
      );

  Map<String, dynamic> toJson() => {
        "purchases": purchases?.toJson(),
        "widget": widget?.toJson(),
      };
}

class Purchases {
  final String? currentPage;
  final List<PurchaseData>? data;
  final String? firstPageUrl;
  final String? from;
  final String? lastPage;
  final String? lastPageUrl;
  final List<Link>? links;
  final String? nextPageUrl;
  final String? path;
  final String? perPage;
  final String? prevPageUrl;
  final String? to;
  final String? total;

  Purchases({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.links,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory Purchases.fromJson(Map<String, dynamic> json) => Purchases(
        currentPage: json["current_page"].toString(),
        data: json["data"] == null
            ? []
            : List<PurchaseData>.from(
                json["data"]!.map((x) => PurchaseData.fromJson(x))),
        firstPageUrl: json["first_page_url"].toString(),
        from: json["from"].toString(),
        lastPage: json["last_page"].toString(),
        lastPageUrl: json["last_page_url"].toString(),
        links: json["links"] == null
            ? []
            : List<Link>.from(json["links"]!.map((x) => Link.fromJson(x))),
        nextPageUrl: json["next_page_url"].toString(),
        path: json["path"].toString(),
        perPage: json["per_page"].toString(),
        prevPageUrl: json["prev_page_url"].toString(),
        to: json["to"].toString(),
        total: json["total"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "links": links == null
            ? []
            : List<dynamic>.from(links!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class PurchaseData {
  final String? id;
  final String? invoiceNumber;
  final String? referenceNumber;
  final String? purchaseDate;
  final String? supplierId;
  final String? warehouseId;
  final String? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? shippingAmount;
  final String? subtotal;
  final String? total;
  final String? attachment;
  final String? status;
  final String? adminId;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? supplierPaymentsSumAmount;
  final Warehouse? warehouse;
  final Supplier? supplier;
  final List<SupplierPayment>? supplierPayments;

  PurchaseData({
    this.id,
    this.invoiceNumber,
    this.referenceNumber,
    this.purchaseDate,
    this.supplierId,
    this.warehouseId,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.shippingAmount,
    this.subtotal,
    this.total,
    this.attachment,
    this.status,
    this.adminId,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.supplierPaymentsSumAmount,
    this.warehouse,
    this.supplier,
    this.supplierPayments,
  });

  factory PurchaseData.fromJson(Map<String, dynamic> json) => PurchaseData(
        id: json["id"].toString(),
        invoiceNumber: json["invoice_number"].toString(),
        referenceNumber: json["reference_number"].toString(),
        purchaseDate: json["purchase_date"].toString(),
        supplierId: json["supplier_id"].toString(),
        warehouseId: json["warehouse_id"].toString(),
        discountType: json["discount_type"].toString(),
        discountValue: json["discount_value"].toString(),
        discountAmount: json["discount_amount"].toString(),
        shippingAmount: json["shipping_amount"].toString(),
        subtotal: json["subtotal"].toString(),
        total: json["total"].toString(),
        attachment: json["attachment"].toString(),
        status: json["status"].toString(),
        adminId: json["admin_id"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        supplierPaymentsSumAmount:
            json["supplier_payments_sum_amount"]?.toString(),
        warehouse: json["warehouse"] == null
            ? null
            : Warehouse.fromJson(json["warehouse"]),
        supplier: json["supplier"] == null
            ? null
            : Supplier.fromJson(json["supplier"]),
        supplierPayments: json["supplier_payments"] == null
            ? []
            : List<SupplierPayment>.from(json["supplier_payments"]!
                .map((x) => SupplierPayment.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "invoice_number": invoiceNumber,
        "reference_number": referenceNumber,
        "purchase_date": purchaseDate,
        "supplier_id": supplierId,
        "warehouse_id": warehouseId,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "shipping_amount": shippingAmount,
        "subtotal": subtotal,
        "total": total,
        "attachment": attachment,
        "status": status,
        "admin_id": adminId,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "supplier_payments_sum_amount": supplierPaymentsSumAmount,
        "warehouse": warehouse?.toJson(),
        "supplier": supplier?.toJson(),
        "supplier_payments": supplierPayments == null
            ? []
            : List<dynamic>.from(supplierPayments!.map((x) => x.toJson())),
      };
}

class Supplier {
  final String? id;
  final String? name;
  final String? email;
  final String? mobile;
  final String? companyName;
  final String? address;
  final String? city;
  final String? state;
  final String? country;
  final String? zip;
  final String? postcode;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Supplier({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.companyName,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Supplier.fromJson(Map<String, dynamic> json) => Supplier(
        id: json["id"].toString(),
        name: json["name"].toString(),
        email: json["email"].toString(),
        mobile: json["mobile"].toString(),
        companyName: json["company_name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        country: json["country"].toString(),
        zip: json["zip"].toString(),
        postcode: json["postcode"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "email": email,
        "mobile": mobile,
        "company_name": companyName,
        "address": address,
        "city": city,
        "state": state,
        "country": country,
        "zip": zip,
        "postcode": postcode,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class SupplierPayment {
  final String? id;
  final String? purchaseId;
  final String? supplierId;
  final String? paymentMethodId;
  final String? amount;
  final String? paymentNote;
  final String? paymentDate;
  final String? createdAt;
  final String? updatedAt;
  final PaymentType? paymentType;

  SupplierPayment({
    this.id,
    this.purchaseId,
    this.supplierId,
    this.paymentMethodId,
    this.amount,
    this.paymentNote,
    this.paymentDate,
    this.createdAt,
    this.updatedAt,
    this.paymentType,
  });

  factory SupplierPayment.fromJson(Map<String, dynamic> json) =>
      SupplierPayment(
        id: json["id"].toString(),
        purchaseId: json["purchase_id"].toString(),
        supplierId: json["supplier_id"].toString(),
        paymentMethodId: json["payment_method_id"].toString(),
        amount: json["amount"].toString(),
        paymentNote: json["payment_note"].toString(),
        paymentDate: json["payment_date"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        paymentType: json["payment_type"] == null
            ? null
            : PaymentType.fromJson(json["payment_type"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "purchase_id": purchaseId,
        "supplier_id": supplierId,
        "payment_method_id": paymentMethodId,
        "amount": amount,
        "payment_note": paymentNote,
        "payment_date": paymentDate,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "payment_type": paymentType?.toJson(),
      };
}

class PaymentType {
  final String? id;
  final String? name;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  PaymentType({
    this.id,
    this.name,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory PaymentType.fromJson(Map<String, dynamic> json) => PaymentType(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Warehouse {
  final String? id;
  final String? name;
  final String? address;
  final String? city;
  final String? state;
  final String? postcode;
  final String? contactNumber;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Warehouse({
    this.id,
    this.name,
    this.address,
    this.city,
    this.state,
    this.postcode,
    this.contactNumber,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Warehouse.fromJson(Map<String, dynamic> json) => Warehouse(
        id: json["id"].toString(),
        name: json["name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        postcode: json["postcode"].toString(),
        contactNumber: json["contact_number"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "address": address,
        "city": city,
        "state": state,
        "postcode": postcode,
        "contact_number": contactNumber,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Link {
  final String? url;
  final String? label;
  final bool? active;

  Link({
    this.url,
    this.label,
    this.active,
  });

  factory Link.fromJson(Map<String, dynamic> json) => Link(
        url: json["url"].toString(),
        label: json["label"].toString(),
        active: json["active"],
      );

  Map<String, dynamic> toJson() => {
        "url": url,
        "label": label,
        "active": active,
      };
}

class Widget {
  final String? todayPurchase;
  final String? yesterdayPurchase;
  final String? thisWeekPurchase;
  final String? last7DaysWeekPurchase;
  final String? thisMonthPurchase;
  final String? last30DaysMonthPurchase;
  final String? allPurchase;
  final String? lastPurchaseAmount;

  Widget({
    this.todayPurchase,
    this.yesterdayPurchase,
    this.thisWeekPurchase,
    this.last7DaysWeekPurchase,
    this.thisMonthPurchase,
    this.last30DaysMonthPurchase,
    this.allPurchase,
    this.lastPurchaseAmount,
  });

  factory Widget.fromJson(Map<String, dynamic> json) => Widget(
        todayPurchase: json["today_purchase"].toString(),
        yesterdayPurchase: json["yesterday_purchase"].toString(),
        thisWeekPurchase: json["this_week_purchase"].toString(),
        last7DaysWeekPurchase: json["last_7days_week_purchase"].toString(),
        thisMonthPurchase: json["this_month_purchase"].toString(),
        last30DaysMonthPurchase: json["last_30days_month_purchase"].toString(),
        allPurchase: json["all_purchase"].toString(),
        lastPurchaseAmount: json["last_purchase_amount"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "today_purchase": todayPurchase,
        "yesterday_purchase": yesterdayPurchase,
        "this_week_purchase": thisWeekPurchase,
        "last_7days_week_purchase": last7DaysWeekPurchase,
        "this_month_purchase": thisMonthPurchase,
        "last_30days_month_purchase": last30DaysMonthPurchase,
        "all_purchase": allPurchase,
        "last_purchase_amount": lastPurchaseAmount,
      };
}
