// To parse this JSON data, do
//
//     final purchaseAttachmentResponseModel = purchaseAttachmentResponseModelFromJson(jsonString);

import 'dart:convert';

PurchaseAttachmentResponseModel purchaseAttachmentResponseModelFromJson(
        String str) =>
    PurchaseAttachmentResponseModel.fromJson(json.decode(str));

String purchaseAttachmentResponseModelToJson(
        PurchaseAttachmentResponseModel data) =>
    json.encode(data.toJson());

class PurchaseAttachmentResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  PurchaseAttachmentResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory PurchaseAttachmentResponseModel.fromJson(Map<String, dynamic> json) =>
      PurchaseAttachmentResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  String? url;

  Data({
    this.url,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        url: json["url"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "url": url,
      };
}
