// To parse this JSON data, do
//
//     final newPurchaseDataResponseModel = newPurchaseDataResponseModelFromJson(jsonString);

import 'dart:convert';
import 'dart:io';

import 'package:flutter/material.dart';
import 'package:ovosale/data/model/payment_method/payment_account_resonse_model.dart';

NewPurchaseDataResponseModel newPurchaseDataResponseModelFromJson(String str) =>
    NewPurchaseDataResponseModel.fromJson(json.decode(str));

String newPurchaseDataResponseModelToJson(NewPurchaseDataResponseModel data) =>
    json.encode(data.toJson());

class NewPurchaseDataResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  NewPurchaseDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory NewPurchaseDataResponseModel.fromJson(Map<String, dynamic> json) =>
      NewPurchaseDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final List<Warehouse>? warehouses;
  final List<PaymentMethod>? taxes;
  final List<PaymentMethod>? paymentMethods;
  final List<Supplier>? suppliers;

  Data({
    this.warehouses,
    this.taxes,
    this.paymentMethods,
    this.suppliers,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        warehouses: json["warehouses"] == null
            ? []
            : List<Warehouse>.from(
                json["warehouses"]!.map((x) => Warehouse.fromJson(x))),
        taxes: json["taxes"] == null
            ? []
            : List<PaymentMethod>.from(
                json["taxes"]!.map((x) => PaymentMethod.fromJson(x))),
        paymentMethods: json["paymentMethods"] == null
            ? []
            : List<PaymentMethod>.from(
                json["paymentMethods"]!.map((x) => PaymentMethod.fromJson(x))),
        suppliers: json["suppliers"] == null
            ? []
            : List<Supplier>.from(
                json["suppliers"]!.map((x) => Supplier.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "warehouses": warehouses == null
            ? []
            : List<dynamic>.from(warehouses!.map((x) => x.toJson())),
        "taxes": taxes == null
            ? []
            : List<dynamic>.from(taxes!.map((x) => x.toJson())),
        "paymentMethods": paymentMethods == null
            ? []
            : List<dynamic>.from(paymentMethods!.map((x) => x.toJson())),
        "suppliers": suppliers == null
            ? []
            : List<dynamic>.from(suppliers!.map((x) => x.toJson())),
      };
}

class PaymentMethod {
  final String? id;
  final String? name;
  final String? status;
  final String? isDefault;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? percentage;
  List<PaymentAccountModel>? paymentAccounts;

  PaymentMethod({
    this.id,
    this.name,
    this.status,
    this.isDefault,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.percentage,
    this.paymentAccounts,
  });

  factory PaymentMethod.fromJson(Map<String, dynamic> json) => PaymentMethod(
        id: json["id"]?.toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        isDefault: json["is_default"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        percentage: json["percentage"].toString(),
        paymentAccounts: json["payment_accounts"] == null
            ? []
            : List<PaymentAccountModel>.from(json["payment_accounts"]!
                .map((x) => PaymentAccountModel.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "is_default": isDefault,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "percentage": percentage,
        "payment_accounts": paymentAccounts == null
            ? []
            : List<dynamic>.from(paymentAccounts!.map((x) => x.toJson())),
      };
}

class Supplier {
  final String? id;
  final String? name;
  final String? email;
  final String? mobile;
  final String? companyName;
  final String? address;
  final String? city;
  final String? state;
  final String? country;
  final String? zip;
  final String? postcode;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Supplier({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.companyName,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Supplier.fromJson(Map<String, dynamic> json) => Supplier(
        id: json["id"].toString(),
        name: json["name"].toString(),
        email: json["email"].toString(),
        mobile: json["mobile"].toString(),
        companyName: json["company_name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        country: json["country"].toString(),
        zip: json["zip"].toString(),
        postcode: json["postcode"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "email": email,
        "mobile": mobile,
        "company_name": companyName,
        "address": address,
        "city": city,
        "state": state,
        "country": country,
        "zip": zip,
        "postcode": postcode,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Warehouse {
  final String? id;
  final String? name;
  final String? address;
  final String? city;
  final String? state;
  final String? postcode;
  final String? contactNumber;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Warehouse({
    this.id,
    this.name,
    this.address,
    this.city,
    this.state,
    this.postcode,
    this.contactNumber,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Warehouse.fromJson(Map<String, dynamic> json) => Warehouse(
        id: json["id"].toString(),
        name: json["name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        postcode: json["postcode"].toString(),
        contactNumber: json["contact_number"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "address": address,
        "city": city,
        "state": state,
        "postcode": postcode,
        "contact_number": contactNumber,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class NewPurchaseFormModel {
  String? pruchaseDate;
  String? productId;
  String? variantId;
  String? purchaseDetailsId;
  String? productDetailId;
  String? supplier;
  String? warehouse;
  String? productName;
  String? status;
  String? selectedTax;
  String? taxType;
  String? taxId;
  String? discountType;
  String? discount;
  String? vatPercentage;
  String? finalPrice;
  String? referenceNumber;
  String? subTitleVariantText;
  bool removable;
  TextEditingController? finalSalePriceController;
  TextEditingController? quantityController;
  TextEditingController? basePriceController;
  TextEditingController? purchasePriceController;
  TextEditingController? subTotalController;
  TextEditingController? profitMarginController;
  TextEditingController? salePriceController;
  TextEditingController? saleDiscountController;
  TextEditingController? finalPriceController;
  TextEditingController? alartQuantity;
  File? attachment;

  NewPurchaseFormModel(
      {this.pruchaseDate,
      this.supplier,
      this.warehouse,
      this.productId,
      this.variantId,
      this.purchaseDetailsId,
      this.taxId,
      this.discountType,
      this.discount,
      this.productDetailId,
      this.taxType,
      this.vatPercentage,
      this.finalPrice,
      this.status,
      this.productName,
      this.selectedTax,
      this.attachment,
      this.subTitleVariantText,
      this.removable = true,
      this.finalSalePriceController,
      this.quantityController,
      this.basePriceController,
      this.purchasePriceController,
      this.subTotalController,
      this.profitMarginController,
      this.salePriceController,
      this.finalPriceController,
      this.saleDiscountController,
      this.alartQuantity,
      this.referenceNumber}) {
    finalSalePriceController ??= TextEditingController();
    quantityController ??= TextEditingController();
    basePriceController ??= TextEditingController();
    purchasePriceController ??= TextEditingController();
    subTotalController ??= TextEditingController();
    profitMarginController ??= TextEditingController();
    salePriceController ??= TextEditingController();
    saleDiscountController ??= TextEditingController();
    finalPriceController ??= TextEditingController();
  }
}
