// To parse this JSON data, do
//
//     final editPurchaseResponseModel = editPurchaseResponseModelFromJson(jsonString);

import 'dart:convert';

EditPurchaseResponseModel editPurchaseResponseModelFromJson(String str) =>
    EditPurchaseResponseModel.fromJson(json.decode(str));

String editPurchaseResponseModelToJson(EditPurchaseResponseModel data) =>
    json.encode(data.toJson());

class EditPurchaseResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  EditPurchaseResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory EditPurchaseResponseModel.fromJson(Map<String, dynamic> json) =>
      EditPurchaseResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final List<Warehouse>? warehouses;
  final List<PaymentMethod>? taxes;
  final List<PaymentMethod>? paymentMethods;
  final List<Supplier>? suppliers;
  final Purchase? purchase;

  Data({
    this.warehouses,
    this.taxes,
    this.paymentMethods,
    this.suppliers,
    this.purchase,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        warehouses: json["warehouses"] == null
            ? []
            : List<Warehouse>.from(
                json["warehouses"]!.map((x) => Warehouse.fromJson(x))),
        taxes: json["taxes"] == null
            ? []
            : List<PaymentMethod>.from(
                json["taxes"]!.map((x) => PaymentMethod.fromJson(x))),
        paymentMethods: json["paymentMethods"] == null
            ? []
            : List<PaymentMethod>.from(
                json["paymentMethods"]!.map((x) => PaymentMethod.fromJson(x))),
        suppliers: json["suppliers"] == null
            ? []
            : List<Supplier>.from(
                json["suppliers"]!.map((x) => Supplier.fromJson(x))),
        purchase: json["purchase"] == null
            ? null
            : Purchase.fromJson(json["purchase"]),
      );

  Map<String, dynamic> toJson() => {
        "warehouses": warehouses == null
            ? []
            : List<dynamic>.from(warehouses!.map((x) => x.toJson())),
        "taxes": taxes == null
            ? []
            : List<dynamic>.from(taxes!.map((x) => x.toJson())),
        "paymentMethods": paymentMethods == null
            ? []
            : List<dynamic>.from(paymentMethods!.map((x) => x.toJson())),
        "suppliers": suppliers == null
            ? []
            : List<dynamic>.from(suppliers!.map((x) => x.toJson())),
        "purchase": purchase?.toJson(),
      };
}

class PaymentMethod {
  final String? id;
  final String? name;
  final String? status;
  final String? isDefault;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? attributeId;
  final String? percentage;

  PaymentMethod({
    this.id,
    this.name,
    this.status,
    this.isDefault,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.attributeId,
    this.percentage,
  });

  factory PaymentMethod.fromJson(Map<String, dynamic> json) => PaymentMethod(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        isDefault: json["is_default"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        attributeId: json["attribute_id"].toString(),
        percentage: json["percentage"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "is_default": isDefault,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "attribute_id": attributeId,
        "percentage": percentage,
      };
}

class Purchase {
  final String? id;
  final String? invoiceNumber;
  final String? referenceNumber;
  final String? purchaseDate;
  final String? supplierId;
  final String? warehouseId;
  final String? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? shippingAmount;
  final String? subtotal;
  final String? total;
  final String? attachment;
  final String? status;
  final String? adminId;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final List<PurchaseDetail>? purchaseDetails;

  Purchase({
    this.id,
    this.invoiceNumber,
    this.referenceNumber,
    this.purchaseDate,
    this.supplierId,
    this.warehouseId,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.shippingAmount,
    this.subtotal,
    this.total,
    this.attachment,
    this.status,
    this.adminId,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.purchaseDetails,
  });

  factory Purchase.fromJson(Map<String, dynamic> json) => Purchase(
        id: json["id"].toString(),
        invoiceNumber: json["invoice_number"].toString(),
        referenceNumber: json["reference_number"].toString(),
        purchaseDate: json["purchase_date"].toString(),
        supplierId: json["supplier_id"].toString(),
        warehouseId: json["warehouse_id"].toString(),
        discountType: json["discount_type"].toString(),
        discountValue: json["discount_value"].toString(),
        discountAmount: json["discount_amount"].toString(),
        shippingAmount: json["shipping_amount"].toString(),
        subtotal: json["subtotal"].toString(),
        total: json["total"].toString(),
        attachment: json["attachment"].toString(),
        status: json["status"].toString(),
        adminId: json["admin_id"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        purchaseDetails: json["purchase_details"] == null
            ? []
            : List<PurchaseDetail>.from(json["purchase_details"]!
                .map((x) => PurchaseDetail.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "invoice_number": invoiceNumber,
        "reference_number": referenceNumber,
        "purchase_date": purchaseDate,
        "supplier_id": supplierId,
        "warehouse_id": warehouseId,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "shipping_amount": shippingAmount,
        "subtotal": subtotal,
        "total": total,
        "attachment": attachment,
        "status": status,
        "admin_id": adminId,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "purchase_details": purchaseDetails == null
            ? []
            : List<dynamic>.from(purchaseDetails!.map((x) => x.toJson())),
      };
}

class PurchaseDetail {
  final String? id;
  final String? purchaseId;
  final String? productId;
  final String? productDetailsId;
  final String? basePrice;
  final String? taxId;
  final String? taxType;
  final String? taxAmount;
  final String? taxPercentage;
  final String? purchasePrice;
  final String? profitMargin;
  final String? salePrice;
  final String? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? finalPrice;
  final String? quantity;
  final String? createdAt;
  final String? updatedAt;
  final Product? product;
  final ProductDetail? productDetail;

  PurchaseDetail({
    this.id,
    this.purchaseId,
    this.productId,
    this.productDetailsId,
    this.basePrice,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.purchasePrice,
    this.profitMargin,
    this.salePrice,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.finalPrice,
    this.quantity,
    this.createdAt,
    this.updatedAt,
    this.product,
    this.productDetail,
  });

  factory PurchaseDetail.fromJson(Map<String, dynamic> json) => PurchaseDetail(
        id: json["id"].toString(),
        purchaseId: json["purchase_id"].toString(),
        productId: json["product_id"].toString(),
        productDetailsId: json["product_details_id"].toString(),
        basePrice: json["base_price"].toString(),
        taxId: json["tax_id"].toString(),
        taxType: json["tax_type"].toString(),
        taxAmount: json["tax_amount"].toString(),
        taxPercentage: json["tax_percentage"].toString(),
        purchasePrice: json["purchase_price"].toString(),
        profitMargin: json["profit_margin"].toString(),
        salePrice: json["sale_price"].toString(),
        discountType: json["discount_type"].toString(),
        discountValue: json["discount_value"].toString(),
        discountAmount: json["discount_amount"].toString(),
        finalPrice: json["final_price"].toString(),
        quantity: json["quantity"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        product:
            json["product"] == null ? null : Product.fromJson(json["product"]),
        productDetail: json["product_detail"] == null
            ? null
            : ProductDetail.fromJson(json["product_detail"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "purchase_id": purchaseId,
        "product_id": productId,
        "product_details_id": productDetailsId,
        "base_price": basePrice,
        "tax_id": taxId,
        "tax_type": taxType,
        "tax_amount": taxAmount,
        "tax_percentage": taxPercentage,
        "purchase_price": purchasePrice,
        "profit_margin": profitMargin,
        "sale_price": salePrice,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "final_price": finalPrice,
        "quantity": quantity,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "product": product?.toJson(),
        "product_detail": productDetail?.toJson(),
      };
}

class Product {
  final String? id;
  final String? name;
  final String? productCode;
  final String? productType;
  final String? categoryId;
  final String? unitId;
  final String? brandId;
  final String? image;
  final String? description;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? imageSrc;

  Product({
    this.id,
    this.name,
    this.productCode,
    this.productType,
    this.categoryId,
    this.unitId,
    this.brandId,
    this.image,
    this.description,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
  });

  factory Product.fromJson(Map<String, dynamic> json) => Product(
        id: json["id"].toString(),
        name: json["name"].toString(),
        productCode: json["product_code"].toString(),
        productType: json["product_type"].toString(),
        categoryId: json["category_id"].toString(),
        unitId: json["unit_id"].toString(),
        brandId: json["brand_id"].toString(),
        image: json["image"].toString(),
        description: json["description"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        imageSrc: json["image_src"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "product_code": productCode,
        "product_type": productType,
        "category_id": categoryId,
        "unit_id": unitId,
        "brand_id": brandId,
        "image": image,
        "description": description,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "image_src": imageSrc,
      };
}

class ProductDetail {
  final String? id;
  final String? productId;
  final String? sku;
  final String? basePrice;
  final String? taxId;
  final String? taxType;
  final String? taxAmount;
  final String? taxPercentage;
  final String? purchasePrice;
  final String? profitMargin;
  final String? salePrice;
  final String? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? finalPrice;
  final String? alertQuantity;
  final String? variantId;
  final String? attributeId;
  final String? createdAt;
  final String? updatedAt;
  final PaymentMethod? attribute;
  final PaymentMethod? variant;

  ProductDetail({
    this.id,
    this.productId,
    this.sku,
    this.basePrice,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.purchasePrice,
    this.profitMargin,
    this.salePrice,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.finalPrice,
    this.alertQuantity,
    this.variantId,
    this.attributeId,
    this.createdAt,
    this.updatedAt,
    this.attribute,
    this.variant,
  });

  factory ProductDetail.fromJson(Map<String, dynamic> json) => ProductDetail(
        id: json["id"].toString(),
        productId: json["product_id"].toString(),
        sku: json["sku"].toString(),
        basePrice: json["base_price"].toString(),
        taxId: json["tax_id"].toString(),
        taxType: json["tax_type"].toString(),
        taxAmount: json["tax_amount"].toString(),
        taxPercentage: json["tax_percentage"].toString(),
        purchasePrice: json["purchase_price"].toString(),
        profitMargin: json["profit_margin"].toString(),
        salePrice: json["sale_price"].toString(),
        discountType: json["discount_type"].toString(),
        discountValue: json["discount_value"].toString(),
        discountAmount: json["discount_amount"].toString(),
        finalPrice: json["final_price"].toString(),
        alertQuantity: json["alert_quantity"].toString(),
        variantId: json["variant_id"].toString(),
        attributeId: json["attribute_id"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        attribute: json["attribute"] == null
            ? null
            : PaymentMethod.fromJson(json["attribute"]),
        variant: json["variant"] == null
            ? null
            : PaymentMethod.fromJson(json["variant"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "product_id": productId,
        "sku": sku,
        "base_price": basePrice,
        "tax_id": taxId,
        "tax_type": taxType,
        "tax_amount": taxAmount,
        "tax_percentage": taxPercentage,
        "purchase_price": purchasePrice,
        "profit_margin": profitMargin,
        "sale_price": salePrice,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "final_price": finalPrice,
        "alert_quantity": alertQuantity,
        "variant_id": variantId,
        "attribute_id": attributeId,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "attribute": attribute?.toJson(),
        "variant": variant?.toJson(),
      };
}

class Supplier {
  final String? id;
  final String? name;
  final String? email;
  final String? mobile;
  final String? companyName;
  final String? address;
  final String? city;
  final String? state;
  final String? country;
  final String? zip;
  final String? postcode;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Supplier({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.companyName,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Supplier.fromJson(Map<String, dynamic> json) => Supplier(
        id: json["id"].toString(),
        name: json["name"].toString(),
        email: json["email"].toString(),
        mobile: json["mobile"].toString(),
        companyName: json["company_name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        country: json["country"].toString(),
        zip: json["zip"].toString(),
        postcode: json["postcode"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "email": email,
        "mobile": mobile,
        "company_name": companyName,
        "address": address,
        "city": city,
        "state": state,
        "country": country,
        "zip": zip,
        "postcode": postcode,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Warehouse {
  final String? id;
  final String? name;
  final String? address;
  final String? city;
  final String? state;
  final String? postcode;
  final String? contactNumber;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Warehouse({
    this.id,
    this.name,
    this.address,
    this.city,
    this.state,
    this.postcode,
    this.contactNumber,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Warehouse.fromJson(Map<String, dynamic> json) => Warehouse(
        id: json["id"].toString(),
        name: json["name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        postcode: json["postcode"].toString(),
        contactNumber: json["contact_number"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "address": address,
        "city": city,
        "state": state,
        "postcode": postcode,
        "contact_number": contactNumber,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
