// To parse this JSON data, do
//
//     final profileEditResponseModel = profileEditResponseModelFromJson(jsonString);

import 'dart:convert';

ProfileEditResponseModel profileEditResponseModelFromJson(String str) =>
    ProfileEditResponseModel.fromJson(json.decode(str));

String profileEditResponseModelToJson(ProfileEditResponseModel data) =>
    json.encode(data.toJson());

class ProfileEditResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  ProfileEditResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ProfileEditResponseModel.fromJson(Map<String, dynamic> json) =>
      ProfileEditResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Admin? admin;

  Data({
    this.admin,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        admin: json["admin"] == null ? null : Admin.fromJson(json["admin"]),
      );

  Map<String, dynamic> toJson() => {
        "admin": admin?.toJson(),
      };
}

class Admin {
  String? id;
  String? name;
  String? email;
  String? username;
  String? emailVerifiedAt;
  String? image;
  String? status;
  String? createdAt;
  String? updatedAt;
  String? imageSrc;

  Admin({
    this.id,
    this.name,
    this.email,
    this.username,
    this.emailVerifiedAt,
    this.image,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
  });

  factory Admin.fromJson(Map<String, dynamic> json) => Admin(
        id: json["id"]?.toString() ?? "",
        name: json["name"]?.toString() ?? "",
        email: json["email"]?.toString() ?? "",
        username: json["username"]?.toString() ?? "",
        emailVerifiedAt: json["email_verified_at"]?.toString() ?? "",
        image: json["image"]?.toString() ?? "",
        status: json["status"]?.toString() ?? "",
        createdAt: json["created_at"]?.toString() ?? "",
        updatedAt: json["updated_at"]?.toString() ?? "",
        imageSrc: json["image_src"]?.toString() ?? "",
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "email": email,
        "username": username,
        "email_verified_at": emailVerifiedAt,
        "image": image,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "image_src": imageSrc,
      };
}
