// To parse this JSON data, do
//
//     final productDetailsResponseModel = productDetailsResponseModelFromJson(jsonString);

import 'dart:convert';

ProductDetailsResponseModel productDetailsResponseModelFromJson(String str) =>
    ProductDetailsResponseModel.fromJson(json.decode(str));

String productDetailsResponseModelToJson(ProductDetailsResponseModel data) =>
    json.encode(data.toJson());

class ProductDetailsResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  ProductDetailsResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ProductDetailsResponseModel.fromJson(Map<String, dynamic> json) =>
      ProductDetailsResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Product? product;

  Data({
    this.product,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        product:
            json["product"] == null ? null : Product.fromJson(json["product"]),
      );

  Map<String, dynamic> toJson() => {
        "product": product?.toJson(),
      };
}

class Product {
  final String? id;
  final String? name;
  final String? productCode;
  final String? productType;
  final String? categoryId;
  final String? unitId;
  final String? brandId;
  final String? image;
  final String? description;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? imageSrc;
  final List<Detail>? details;
  final Brand? category;
  final Brand? brand;
  final Brand? unit;

  Product({
    this.id,
    this.name,
    this.productCode,
    this.productType,
    this.categoryId,
    this.unitId,
    this.brandId,
    this.image,
    this.description,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
    this.details,
    this.category,
    this.brand,
    this.unit,
  });

  factory Product.fromJson(Map<String, dynamic> json) => Product(
        id: json["id"].toString(),
        name: json["name"].toString(),
        productCode: json["product_code"].toString(),
        productType: json["product_type"].toString(),
        categoryId: json["category_id"].toString(),
        unitId: json["unit_id"].toString(),
        brandId: json["brand_id"].toString(),
        image: json["image"].toString(),
        description: json["description"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        imageSrc: json["image_src"].toString(),
        details: json["details"] == null
            ? []
            : List<Detail>.from(
                json["details"]!.map((x) => Detail.fromJson(x))),
        category:
            json["category"] == null ? null : Brand.fromJson(json["category"]),
        brand: json["brand"] == null ? null : Brand.fromJson(json["brand"]),
        unit: json["unit"] == null ? null : Brand.fromJson(json["unit"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "product_code": productCode,
        "product_type": productType,
        "category_id": categoryId,
        "unit_id": unitId,
        "brand_id": brandId,
        "image": image,
        "description": description,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "image_src": imageSrc,
        "details": details == null
            ? []
            : List<dynamic>.from(details!.map((x) => x.toJson())),
        "category": category?.toJson(),
        "brand": brand?.toJson(),
        "unit": unit?.toJson(),
      };
}

class Brand {
  final String? id;
  final String? name;
  final String? status;
  final String? image;
  final String? createdAt;
  final String? updatedAt;
  final String? deletedAt;
  final String? imageSrc;
  final String? shortName;

  Brand({
    this.id,
    this.name,
    this.status,
    this.image,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
    this.imageSrc,
    this.shortName,
  });

  factory Brand.fromJson(Map<String, dynamic> json) => Brand(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        image: json["image"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        deletedAt: json["deleted_at"].toString(),
        imageSrc: json["image_src"].toString(),
        shortName: json["short_name"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "image": image,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "deleted_at": deletedAt,
        "image_src": imageSrc,
        "short_name": shortName,
      };
}

class Detail {
  final String? id;
  final String? productId;
  final String? sku;
  final String? basePrice;
  final String? taxId;
  final String? taxType;
  final String? taxAmount;
  final String? taxPercentage;
  final String? purchasePrice;
  final String? profitMargin;
  final String? salePrice;
  final String? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? finalPrice;
  final String? alertQuantity;
  final String? variantId;
  final String? attributeId;
  final String? createdAt;
  final String? updatedAt;
  final Attribute? attribute;
  final Attribute? variant;
  final Attribute? tax;

  Detail({
    this.id,
    this.productId,
    this.sku,
    this.basePrice,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.purchasePrice,
    this.profitMargin,
    this.salePrice,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.finalPrice,
    this.alertQuantity,
    this.variantId,
    this.attributeId,
    this.createdAt,
    this.updatedAt,
    this.attribute,
    this.variant,
    this.tax,
  });

  factory Detail.fromJson(Map<String, dynamic> json) => Detail(
        id: json["id"].toString(),
        productId: json["product_id"].toString(),
        sku: json["sku"].toString(),
        basePrice: json["base_price"].toString(),
        taxId: json["tax_id"].toString(),
        taxType: json["tax_type"].toString(),
        taxAmount: json["tax_amount"].toString(),
        taxPercentage: json["tax_percentage"].toString(),
        purchasePrice: json["purchase_price"].toString(),
        profitMargin: json["profit_margin"].toString(),
        salePrice: json["sale_price"].toString(),
        discountType: json["discount_type"].toString(),
        discountValue: json["discount_value"].toString(),
        discountAmount: json["discount_amount"].toString(),
        finalPrice: json["final_price"].toString(),
        alertQuantity: json["alert_quantity"].toString(),
        variantId: json["variant_id"].toString(),
        attributeId: json["attribute_id"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        attribute: json["attribute"] == null
            ? null
            : Attribute.fromJson(json["attribute"]),
        variant: json["variant"] == null
            ? null
            : Attribute.fromJson(json["variant"]),
        tax: json["tax"] == null ? null : Attribute.fromJson(json["tax"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "product_id": productId,
        "sku": sku,
        "base_price": basePrice,
        "tax_id": taxId,
        "tax_type": taxType,
        "tax_amount": taxAmount,
        "tax_percentage": taxPercentage,
        "purchase_price": purchasePrice,
        "profit_margin": profitMargin,
        "sale_price": salePrice,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "final_price": finalPrice,
        "alert_quantity": alertQuantity,
        "variant_id": variantId,
        "attribute_id": attributeId,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "attribute": attribute?.toJson(),
        "variant": variant?.toJson(),
        "tax": tax?.toJson(),
      };
}

class Attribute {
  final String? id;
  final String? name;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? percentage;
  final String? attributeId;

  Attribute({
    this.id,
    this.name,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.percentage,
    this.attributeId,
  });

  factory Attribute.fromJson(Map<String, dynamic> json) => Attribute(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        percentage: json["percentage"].toString(),
        attributeId: json["attribute_id"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "percentage": percentage,
        "attribute_id": attributeId,
      };
}
