// To parse this JSON data, do
//
//     final updateProductResponseModel = updateProductResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:ovosale/data/model/product/global_attribute_model.dart';

UpdateProductResponseModel updateProductResponseModelFromJson(String str) =>
    UpdateProductResponseModel.fromJson(json.decode(str));

String updateProductResponseModelToJson(UpdateProductResponseModel data) =>
    json.encode(data.toJson());

class UpdateProductResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  UpdateProductResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory UpdateProductResponseModel.fromJson(Map<String, dynamic> json) =>
      UpdateProductResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final List<Attribute>? categories;
  final List<Attribute>? units;
  final List<Attribute>? brands;
  final List<Attribute>? taxes;
  final List<Attribute>? attributes;
  final Product? product;

  Data({
    this.categories,
    this.units,
    this.brands,
    this.taxes,
    this.attributes,
    this.product,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        categories: json["categories"] == null
            ? []
            : List<Attribute>.from(
                json["categories"]!.map((x) => Attribute.fromJson(x))),
        units: json["units"] == null
            ? []
            : List<Attribute>.from(
                json["units"]!.map((x) => Attribute.fromJson(x))),
        brands: json["brands"] == null
            ? []
            : List<Attribute>.from(
                json["brands"]!.map((x) => Attribute.fromJson(x))),
        taxes: json["taxes"] == null
            ? []
            : List<Attribute>.from(
                json["taxes"]!.map((x) => Attribute.fromJson(x))),
        attributes: json["attributes"] == null
            ? []
            : List<Attribute>.from(
                json["attributes"]!.map((x) => Attribute.fromJson(x))),
        product:
            json["product"] == null ? null : Product.fromJson(json["product"]),
      );

  Map<String, dynamic> toJson() => {
        "categories": categories == null
            ? []
            : List<dynamic>.from(categories!.map((x) => x.toJson())),
        "units": units == null
            ? []
            : List<dynamic>.from(units!.map((x) => x.toJson())),
        "brands": brands == null
            ? []
            : List<dynamic>.from(brands!.map((x) => x.toJson())),
        "taxes": taxes == null
            ? []
            : List<dynamic>.from(taxes!.map((x) => x.toJson())),
        "attributes": attributes == null
            ? []
            : List<dynamic>.from(attributes!.map((x) => x.toJson())),
        "product": product?.toJson(),
      };
}

class Product {
  final String? id;
  final String? name;
  final String? productCode;
  final String? productType;
  final String? categoryId;
  final String? unitId;
  final String? brandId;
  final String? image;
  final String? description;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? imageSrc;
  final List<ProductDetail>? details;

  Product({
    this.id,
    this.name,
    this.productCode,
    this.productType,
    this.categoryId,
    this.unitId,
    this.brandId,
    this.image,
    this.description,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
    this.details,
  });

  factory Product.fromJson(Map<String, dynamic> json) => Product(
        id: json["id"].toString(),
        name: json["name"].toString(),
        productCode: json["product_code"].toString(),
        productType: json["product_type"].toString(),
        categoryId: json["category_id"].toString(),
        unitId: json["unit_id"].toString(),
        brandId: json["brand_id"].toString(),
        image: json["image"].toString(),
        description: json["description"]?.toString() ?? "",
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        imageSrc: json["image_src"].toString(),
        details: json["details"] == null
            ? []
            : List<ProductDetail>.from(
                json["details"]!.map((x) => ProductDetail.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "product_code": productCode,
        "product_type": productType,
        "category_id": categoryId,
        "unit_id": unitId,
        "brand_id": brandId,
        "image": image,
        "description": description,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "image_src": imageSrc,
        "details": details == null
            ? []
            : List<dynamic>.from(details!.map((x) => x.toJson())),
      };
}

class ProductDetail {
  final String? id;
  final String? productId;
  final String? sku;
  final String? basePrice;
  final String? taxId;
  final String? taxType;
  final String? taxAmount;
  final String? taxPercentage;
  final String? purchasePrice;
  final String? profitMargin;
  final String? salePrice;
  final String? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? finalPrice;
  final String? alertQuantity;
  final String? variantId;
  final String? attributeId;
  final String? createdAt;
  final String? updatedAt;
  final Attribute? attribute;
  final Attribute? variant;
  final Attribute? tax;

  ProductDetail({
    this.id,
    this.productId,
    this.sku,
    this.basePrice,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.purchasePrice,
    this.profitMargin,
    this.salePrice,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.finalPrice,
    this.alertQuantity,
    this.variantId,
    this.attributeId,
    this.createdAt,
    this.updatedAt,
    this.attribute,
    this.variant,
    this.tax,
  });

  factory ProductDetail.fromJson(Map<String, dynamic> json) => ProductDetail(
        id: json["id"].toString(),
        productId: json["product_id"].toString(),
        sku: json["sku"].toString(),
        basePrice: json["base_price"].toString(),
        taxId: json["tax_id"].toString(),
        taxType: json["tax_type"].toString(),
        taxAmount: json["tax_amount"].toString(),
        taxPercentage: json["tax_percentage"].toString(),
        purchasePrice: json["purchase_price"].toString(),
        profitMargin: json["profit_margin"].toString(),
        salePrice: json["sale_price"].toString(),
        discountType: json["discount_type"].toString(),
        discountValue: json["discount_value"].toString(),
        discountAmount: json["discount_amount"].toString(),
        finalPrice: json["final_price"].toString(),
        alertQuantity: json["alert_quantity"].toString(),
        variantId: json["variant_id"].toString(),
        attributeId: json["attribute_id"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        attribute: json["attribute"] == null
            ? null
            : Attribute.fromJson(json["attribute"]),
        variant: json["variant"] == null
            ? null
            : Attribute.fromJson(json["variant"]),
        tax: json["tax"] == null ? null : Attribute.fromJson(json["tax"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "product_id": productId,
        "sku": sku,
        "base_price": basePrice,
        "tax_id": taxId,
        "tax_type": taxType,
        "tax_amount": taxAmount,
        "tax_percentage": taxPercentage,
        "purchase_price": purchasePrice,
        "profit_margin": profitMargin,
        "sale_price": salePrice,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "final_price": finalPrice,
        "alert_quantity": alertQuantity,
        "variant_id": variantId,
        "attribute_id": attributeId,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "attribute": attribute?.toJson(),
        "variant": variant?.toJson(),
        "tax": tax?.toJson(),
      };
}
