import 'dart:convert';

import 'global_attribute_model.dart';

ProductSearchDataResponseModel productSearchDataResponseModelFromJson(
        String str) =>
    ProductSearchDataResponseModel.fromJson(json.decode(str));

String productSearchDataResponseModelToJson(
        ProductSearchDataResponseModel data) =>
    json.encode(data.toJson());

class ProductSearchDataResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  ProductSearchDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ProductSearchDataResponseModel.fromJson(Map<String, dynamic> json) =>
      ProductSearchDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final List<ProductElement>? products;
  final bool? exactMatch;

  Data({
    this.products,
    this.exactMatch,
  });
  factory Data.fromJson(Map<String, dynamic> json) => Data(
        products: json["products"] != null && json["products"] is List
            ? List<ProductElement>.from((json["products"] as List)
                .map((x) => ProductElement.fromJson(x)))
            : [],
        exactMatch: json["exact_match"],
      );

  Map<String, dynamic> toJson() => {
        "products": products == null
            ? []
            : List<dynamic>.from(products!.map((x) => x.toJson())),
        "exact_match": exactMatch,
      };
}

class ProductElement {
  final String? id;
  final String? sku;
  final String? name;
  final String? productCode;
  final String? productType;
  final String? imageSrc;
  final String? attributeName;
  final String? variantName;
  final String? inStock;
  final String? unitName;
  final Original? original;

  ProductElement({
    this.id,
    this.sku,
    this.name,
    this.productCode,
    this.productType,
    this.imageSrc,
    this.attributeName,
    this.variantName,
    this.inStock,
    this.unitName,
    this.original,
  });

  factory ProductElement.fromJson(Map<String, dynamic> json) => ProductElement(
        id: json["id"].toString(),
        sku: json["sku"].toString(),
        name: json["name"].toString(),
        productCode: json["product_code"].toString(),
        productType: json["product_type"].toString(),
        imageSrc: json["image_src"].toString(),
        attributeName: json["attribute_name"].toString(),
        variantName: json["variant_name"].toString(),
        inStock: json["in_stock"].toString(),
        unitName: json["unit_name"].toString(),
        original: json["original"] == null
            ? null
            : Original.fromJson(json["original"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "sku": sku,
        "name": name,
        "product_code": productCode,
        "product_type": productType,
        "image_src": imageSrc,
        "attribute_name": attributeName,
        "variant_name": variantName,
        "in_stock": inStock,
        "unit_name": unitName,
        "original": original?.toJson(),
      };
}

class Original {
  final String? id;
  final String? productId;
  final String? sku;
  final String? basePrice;
  final String? taxId;
  final String? taxType;
  final String? taxAmount;
  final String? taxPercentage;
  final String? purchasePrice;
  final String? profitMargin;
  final String? salePrice;
  final String? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? finalPrice;
  final String? alertQuantity;
  final String? variantId;
  final String? attributeId;
  final String? createdAt;
  final String? updatedAt;
  final OriginalProduct? product;
  final Attribute? attribute;
  final Attribute? variant;

  Original({
    this.id,
    this.productId,
    this.sku,
    this.basePrice,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.purchasePrice,
    this.profitMargin,
    this.salePrice,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.finalPrice,
    this.alertQuantity,
    this.variantId,
    this.attributeId,
    this.createdAt,
    this.updatedAt,
    this.product,
    this.attribute,
    this.variant,
  });

  factory Original.fromJson(Map<String, dynamic> json) => Original(
        id: json["id"].toString(),
        productId: json["product_id"].toString(),
        sku: json["sku"].toString(),
        basePrice: json["base_price"].toString(),
        taxId: json["tax_id"].toString(),
        taxType: json["tax_type"].toString(),
        taxAmount: json["tax_amount"].toString(),
        taxPercentage: json["tax_percentage"].toString(),
        purchasePrice: json["purchase_price"].toString(),
        profitMargin: json["profit_margin"].toString(),
        salePrice: json["sale_price"].toString(),
        discountType: json["discount_type"].toString(),
        discountValue: json["discount_value"].toString(),
        discountAmount: json["discount_amount"].toString(),
        finalPrice: json["final_price"].toString(),
        alertQuantity: json["alert_quantity"].toString(),
        variantId: json["variant_id"].toString(),
        attributeId: json["attribute_id"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        product: json["product"] == null
            ? null
            : OriginalProduct.fromJson(json["product"]),
        attribute: json["attribute"] == null
            ? null
            : Attribute.fromJson(json["attribute"]),
        variant: json["variant"] == null
            ? null
            : Attribute.fromJson(json["variant"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "product_id": productId,
        "sku": sku,
        "base_price": basePrice,
        "tax_id": taxId,
        "tax_type": taxType,
        "tax_amount": taxAmount,
        "tax_percentage": taxPercentage,
        "purchase_price": purchasePrice,
        "profit_margin": profitMargin,
        "sale_price": salePrice,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "final_price": finalPrice,
        "alert_quantity": alertQuantity,
        "variant_id": variantId,
        "attribute_id": attributeId,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "product": product?.toJson(),
        "attribute": attribute?.toJson(),
        "variant": variant?.toJson(),
      };
}

class OriginalProduct {
  final String? id;
  final String? name;
  final String? productCode;
  final String? productType;
  final String? categoryId;
  final String? unitId;
  final String? brandId;
  final String? image;
  final String? description;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? imageSrc;
  final Attribute? unit;

  OriginalProduct({
    this.id,
    this.name,
    this.productCode,
    this.productType,
    this.categoryId,
    this.unitId,
    this.brandId,
    this.image,
    this.description,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
    this.unit,
  });

  factory OriginalProduct.fromJson(Map<String, dynamic> json) =>
      OriginalProduct(
        id: json["id"].toString(),
        name: json["name"].toString(),
        productCode: json["product_code"].toString(),
        productType: json["product_type"].toString(),
        categoryId: json["category_id"].toString(),
        unitId: json["unit_id"].toString(),
        brandId: json["brand_id"].toString(),
        image: json["image"].toString(),
        description: json["description"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        imageSrc: json["image_src"].toString(),
        unit: json["unit"] == null ? null : Attribute.fromJson(json["unit"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "product_code": productCode,
        "product_type": productType,
        "category_id": categoryId,
        "unit_id": unitId,
        "brand_id": brandId,
        "image": image,
        "description": description,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "image_src": imageSrc,
        "unit": unit?.toJson(),
      };
}
