// To parse this JSON data, do
//
//     final productResponseModel = productResponseModelFromJson(jsonString);

import 'dart:convert';

ProductResponseModel productResponseModelFromJson(String str) =>
    ProductResponseModel.fromJson(json.decode(str));

String productResponseModelToJson(ProductResponseModel data) =>
    json.encode(data.toJson());

class ProductResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  ProductResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ProductResponseModel.fromJson(Map<String, dynamic> json) =>
      ProductResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Products? products;

  Data({
    this.products,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        products: json["products"] == null
            ? null
            : Products.fromJson(json["products"]),
      );

  Map<String, dynamic> toJson() => {
        "products": products?.toJson(),
      };
}

class Products {
  final String? currentPage;
  final List<ProductsData>? data;
  final String? firstPageUrl;
  final String? from;
  final String? lastPage;
  final String? lastPageUrl;
  final List<Link>? links;
  final String? nextPageUrl;
  final String? path;
  final String? perPage;
  final String? prevPageUrl;
  final String? to;
  final String? total;

  Products({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.links,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory Products.fromJson(Map<String, dynamic> json) => Products(
        currentPage: json["current_page"].toString(),
        data: json["data"] == null
            ? []
            : List<ProductsData>.from(
                json["data"]!.map((x) => ProductsData.fromJson(x))),
        firstPageUrl: json["first_page_url"].toString(),
        from: json["from"].toString(),
        lastPage: json["last_page"].toString(),
        lastPageUrl: json["last_page_url"].toString(),
        links: json["links"] == null
            ? []
            : List<Link>.from(json["links"]!.map((x) => Link.fromJson(x))),
        nextPageUrl: json["next_page_url"].toString(),
        path: json["path"].toString(),
        perPage: json["per_page"].toString(),
        prevPageUrl: json["prev_page_url"].toString(),
        to: json["to"].toString(),
        total: json["total"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "links": links == null
            ? []
            : List<dynamic>.from(links!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class ProductsData {
  final String? id;
  final String? name;
  final String? productCode;
  final String? productType;
  final String? categoryId;
  final String? unitId;
  final String? brandId;
  final String? image;
  final String? description;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? imageSrc;
  final List<Detail>? details;
  final Brand? category;
  final Brand? brand;

  ProductsData({
    this.id,
    this.name,
    this.productCode,
    this.productType,
    this.categoryId,
    this.unitId,
    this.brandId,
    this.image,
    this.description,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
    this.details,
    this.category,
    this.brand,
  });

  factory ProductsData.fromJson(Map<String, dynamic> json) => ProductsData(
        id: json["id"].toString(),
        name: json["name"].toString(),
        productCode: json["product_code"].toString(),
        productType: json["product_type"].toString(),
        categoryId: json["category_id"].toString(),
        unitId: json["unit_id"].toString(),
        brandId: json["brand_id"].toString(),
        image: json["image"].toString(),
        description: json["description"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        imageSrc: json["image_src"].toString(),
        details: json["details"] == null
            ? []
            : List<Detail>.from(
                json["details"]!.map((x) => Detail.fromJson(x))),
        category:
            json["category"] == null ? null : Brand.fromJson(json["category"]),
        brand: json["brand"] == null ? null : Brand.fromJson(json["brand"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "product_code": productCode,
        "product_type": productType,
        "category_id": categoryId,
        "unit_id": unitId,
        "brand_id": brandId,
        "image": image,
        "description": description,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "image_src": imageSrc,
        "details": details == null
            ? []
            : List<dynamic>.from(details!.map((x) => x.toJson())),
        "category": category?.toJson(),
        "brand": brand?.toJson(),
      };
}

class Brand {
  final String? id;
  final String? name;
  final String? status;
  final String? image;
  final String? createdAt;
  final String? updatedAt;
  final String? deletedAt;
  final String? imageSrc;

  Brand({
    this.id,
    this.name,
    this.status,
    this.image,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
    this.imageSrc,
  });

  factory Brand.fromJson(Map<String, dynamic> json) => Brand(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        image: json["image"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        deletedAt: json["deleted_at"].toString(),
        imageSrc: json["image_src"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "image": image,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "deleted_at": deletedAt,
        "image_src": imageSrc,
      };
}

class Detail {
  final String? id;
  final String? productId;
  final String? sku;
  final String? basePrice;
  final String? taxId;
  final String? taxType;
  final String? taxAmount;
  final String? taxPercentage;
  final String? purchasePrice;
  final String? profitMargin;
  final String? salePrice;
  final String? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? finalPrice;
  final String? alertQuantity;
  final String? variantId;
  final String? attributeId;
  final String? createdAt;
  final String? updatedAt;

  Detail({
    this.id,
    this.productId,
    this.sku,
    this.basePrice,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.purchasePrice,
    this.profitMargin,
    this.salePrice,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.finalPrice,
    this.alertQuantity,
    this.variantId,
    this.attributeId,
    this.createdAt,
    this.updatedAt,
  });

  factory Detail.fromJson(Map<String, dynamic> json) => Detail(
        id: json["id"].toString(),
        productId: json["product_id"].toString(),
        sku: json["sku"].toString(),
        basePrice: json["base_price"].toString(),
        taxId: json["tax_id"].toString(),
        taxType: json["tax_type"].toString(),
        taxAmount: json["tax_amount"].toString(),
        taxPercentage: json["tax_percentage"].toString(),
        purchasePrice: json["purchase_price"].toString(),
        profitMargin: json["profit_margin"].toString(),
        salePrice: json["sale_price"].toString(),
        discountType: json["discount_type"].toString(),
        discountValue: json["discount_value"].toString(),
        discountAmount: json["discount_amount"].toString(),
        finalPrice: json["final_price"].toString(),
        alertQuantity: json["alert_quantity"].toString(),
        variantId: json["variant_id"].toString(),
        attributeId: json["attribute_id"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "product_id": productId,
        "sku": sku,
        "base_price": basePrice,
        "tax_id": taxId,
        "tax_type": taxType,
        "tax_amount": taxAmount,
        "tax_percentage": taxPercentage,
        "purchase_price": purchasePrice,
        "profit_margin": profitMargin,
        "sale_price": salePrice,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "final_price": finalPrice,
        "alert_quantity": alertQuantity,
        "variant_id": variantId,
        "attribute_id": attributeId,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Link {
  final String? url;
  final String? label;
  final bool? active;

  Link({
    this.url,
    this.label,
    this.active,
  });

  factory Link.fromJson(Map<String, dynamic> json) => Link(
        url: json["url"].toString(),
        label: json["label"].toString(),
        active: json["active"],
      );

  Map<String, dynamic> toJson() => {
        "url": url,
        "label": label,
        "active": active,
      };
}
