class Attribute {
  final String? id;
  final String? name;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final List<Attribute>? variants;
  final String? attributeId;
  final String? image;
  final String? imageSrc;
  final String? percentage;
  final String? shortName;

  Attribute({
    this.id,
    this.name,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.variants,
    this.attributeId,
    this.image,
    this.imageSrc,
    this.percentage,
    this.shortName,
  });

  factory Attribute.fromJson(Map<String, dynamic> json) => Attribute(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        variants: json["variants"] == null
            ? []
            : List<Attribute>.from(
                json["variants"]!.map((x) => Attribute.fromJson(x))),
        attributeId: json["attribute_id"].toString(),
        image: json["image"].toString(),
        imageSrc: json["image_src"].toString(),
        percentage: json["percentage"].toString(),
        shortName: json["short_name"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "variants": variants == null
            ? []
            : List<dynamic>.from(variants!.map((x) => x.toJson())),
        "attribute_id": attributeId,
        "image": image,
        "image_src": imageSrc,
        "percentage": percentage,
        "short_name": shortName,
      };

  @override
  String toString() {
    return name ?? "";
  }

  bool filter(String query) {
    return (name ?? "").toLowerCase().contains(query.toLowerCase());
  }
}
