// To parse this JSON data, do
//
//     final addNewProductResponseModel = addNewProductResponseModelFromJson(jsonString);

import 'dart:convert';
import 'dart:io';

import 'package:flutter/material.dart';

import 'global_attribute_model.dart';

AddNewProductResponseModel addNewProductResponseModelFromJson(String str) =>
    AddNewProductResponseModel.fromJson(json.decode(str));

String addNewProductResponseModelToJson(AddNewProductResponseModel data) =>
    json.encode(data.toJson());

class AddNewProductResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  AddNewProductResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory AddNewProductResponseModel.fromJson(Map<String, dynamic> json) =>
      AddNewProductResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final List<Attribute>? categories;
  final List<Attribute>? units;
  final List<Attribute>? brands;
  final List<Attribute>? taxes;
  final List<Attribute>? attributes;

  Data({
    this.categories,
    this.units,
    this.brands,
    this.taxes,
    this.attributes,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        categories: json["categories"] == null
            ? []
            : List<Attribute>.from(
                json["categories"]!.map((x) => Attribute.fromJson(x))),
        units: json["units"] == null
            ? []
            : List<Attribute>.from(
                json["units"]!.map((x) => Attribute.fromJson(x))),
        brands: json["brands"] == null
            ? []
            : List<Attribute>.from(
                json["brands"]!.map((x) => Attribute.fromJson(x))),
        taxes: json["taxes"] == null
            ? []
            : List<Attribute>.from(
                json["taxes"]!.map((x) => Attribute.fromJson(x))),
        attributes: json["attributes"] == null
            ? []
            : List<Attribute>.from(
                json["attributes"]!.map((x) => Attribute.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "categories": categories == null
            ? []
            : List<dynamic>.from(categories!.map((x) => x.toJson())),
        "units": units == null
            ? []
            : List<dynamic>.from(units!.map((x) => x.toJson())),
        "brands": brands == null
            ? []
            : List<dynamic>.from(brands!.map((x) => x.toJson())),
        "taxes": taxes == null
            ? []
            : List<dynamic>.from(taxes!.map((x) => x.toJson())),
        "attributes": attributes == null
            ? []
            : List<dynamic>.from(attributes!.map((x) => x.toJson())),
      };
}

class ProductDetailsFormModel {
  String? productName;
  String? productId;
  String? productPrice;
  String? productQuantity;
  String? description;
  String? sku;
  String? variantId;
  String? attributeId;
  String? variantName;
  String? attributeName;
  String? basePrice;
  String? profitMargin;
  String? salePrice;
  String? alertQuantity;
  String? selectedBrand;
  String? productType;
  String? unit;
  String? selectedCategory;
  String? taxType;
  String? taxId;
  String? selectedTax;
  String? discountType;
  String? discount;
  String? vatPercentage;
  String? finalPrice;
  List<Attribute>? categories;
  List<Attribute>? units;
  List<Attribute>? brands;
  List<Attribute>? taxes;
  List<Attribute>? attributes;
  TextEditingController? basePriceController;
  TextEditingController? profitMarginController;
  TextEditingController? discountController;
  TextEditingController? salePriceController;
  TextEditingController? purchasePriceController;
  TextEditingController? finalSalePriceController;
  File? imageFile;

  ProductDetailsFormModel({
    this.productName,
    this.productPrice,
    this.productQuantity,
    this.description,
    this.productId,
    this.sku,
    this.basePrice,
    this.profitMargin,
    this.salePrice,
    this.alertQuantity,
    this.attributeName,
    this.selectedBrand,
    this.productType,
    this.unit,
    this.selectedCategory,
    this.taxType,
    this.selectedTax,
    this.taxId,
    this.discountType,
    this.discount,
    this.variantId,
    this.attributeId,
    this.variantName,
    this.vatPercentage,
    this.finalPrice,
    this.categories,
    this.attributes,
    this.brands,
    this.taxes,
    this.units,
    this.imageFile,
    this.basePriceController,
    this.profitMarginController,
    this.discountController,
    this.salePriceController,
    this.purchasePriceController,
    this.finalSalePriceController,
  }) {
    basePriceController ??= TextEditingController();
    profitMarginController ??= TextEditingController();
    discountController ??= TextEditingController();
    salePriceController ??= TextEditingController();
    purchasePriceController ??= TextEditingController();
    finalSalePriceController ??= TextEditingController();
  }
}
