// To parse this JSON data, do
//
//     final viewSaleResponseModel = viewSaleResponseModelFromJson(jsonString);

import 'dart:convert';

ViewSaleResponseModel viewSaleResponseModelFromJson(String str) =>
    ViewSaleResponseModel.fromJson(json.decode(str));

String viewSaleResponseModelToJson(ViewSaleResponseModel data) =>
    json.encode(data.toJson());

class ViewSaleResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  ViewSaleResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ViewSaleResponseModel.fromJson(Map<String, dynamic> json) =>
      ViewSaleResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  SaleDataModel? sale;
  CompanyInformation? companyInformation;

  Data({
    this.sale,
    this.companyInformation,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        sale: json["sale"] == null ? null : SaleDataModel.fromJson(json["sale"]),
        companyInformation: json["companyInformation"] == null
            ? null
            : CompanyInformation.fromJson(json["companyInformation"]),
      );

  Map<String, dynamic> toJson() => {
        "sale": sale?.toJson(),
        "companyInformation": companyInformation?.toJson(),
      };
}

class CompanyInformation {
  String? name;
  String? email;
  String? phone;
  String? address;

  CompanyInformation({
    this.name,
    this.email,
    this.phone,
    this.address,
  });

  factory CompanyInformation.fromJson(Map<String, dynamic> json) =>
      CompanyInformation(
        name: json["name"]?.toString() ?? "",
        email: json["email"]?.toString() ?? "",
        phone: json["phone"]?.toString() ?? "",
        address: json["address"]?.toString() ?? "",
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "email": email,
        "phone": phone,
        "address": address,
      };
}

class SaleDataModel {
  String? id;
  String? invoiceNumber;
  String? saleDate;
  String? customerId;
  String? warehouseId;
  String? discountType;
  String? discountValue;
  String? discountAmount;
  String? shippingAmount;
  String? subtotal;
  String? total;
  String? payingAmount;
  String? changesAmount;
  String? note;
  String? adminId;
  String? isPosSale;
  String? status;
  String? couponId;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;
  Warehouse? warehouse;
  Customer? customer;
  List<Payment>? payments;
  List<SaleDetail>? saleDetails;

  SaleDataModel({
    this.id,
    this.invoiceNumber,
    this.saleDate,
    this.customerId,
    this.warehouseId,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.shippingAmount,
    this.subtotal,
    this.total,
    this.payingAmount,
    this.changesAmount,
    this.note,
    this.adminId,
    this.isPosSale,
    this.status,
    this.couponId,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.warehouse,
    this.customer,
    this.payments,
    this.saleDetails,
  });

  factory SaleDataModel.fromJson(Map<String, dynamic> json) => SaleDataModel(
        id: json["id"].toString(),
        invoiceNumber: json["invoice_number"].toString(),
        saleDate: json["sale_date"].toString(),
        customerId: json["customer_id"].toString(),
        warehouseId: json["warehouse_id"].toString(),
        discountType: json["discount_type"].toString(),
        discountValue: json["discount_value"].toString(),
        discountAmount: json["discount_amount"].toString(),
        shippingAmount: json["shipping_amount"].toString(),
        subtotal: json["subtotal"].toString(),
        total: json["total"].toString(),
        payingAmount: json["paying_amount"].toString(),
        changesAmount: json["changes_amount"].toString(),
        note: json["note"].toString(),
        adminId: json["admin_id"].toString(),
        isPosSale: json["is_pos_sale"].toString(),
        status: json["status"].toString(),
        couponId: json["coupon_id"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        warehouse: json["warehouse"] == null
            ? null
            : Warehouse.fromJson(json["warehouse"]),
        customer: json["customer"] == null
            ? null
            : Customer.fromJson(json["customer"]),
        payments: json["payments"] == null
            ? []
            : List<Payment>.from(
                json["payments"]!.map((x) => Payment.fromJson(x))),
        saleDetails: json["sale_details"] == null
            ? []
            : List<SaleDetail>.from(
                json["sale_details"]!.map((x) => SaleDetail.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "invoice_number": invoiceNumber,
        "sale_date": saleDate,
        "customer_id": customerId,
        "warehouse_id": warehouseId,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "shipping_amount": shippingAmount,
        "subtotal": subtotal,
        "total": total,
        "paying_amount": payingAmount,
        "changes_amount": changesAmount,
        "note": note,
        "admin_id": adminId,
        "is_pos_sale": isPosSale,
        "status": status,
        "coupon_id": couponId,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "warehouse": warehouse?.toJson(),
        "customer": customer?.toJson(),
        "payments": payments == null
            ? []
            : List<dynamic>.from(payments!.map((x) => x.toJson())),
        "sale_details": saleDetails == null
            ? []
            : List<dynamic>.from(saleDetails!.map((x) => x.toJson())),
      };
}

class SaleDetail {
  String? id;
  String? saleId;
  String? productId;
  String? productDetailsId;
  String? taxId;
  String? taxType;
  String? taxAmount;
  String? taxPercentage;
  String? discountType;
  String? discountValue;
  String? discountAmount;
  String? purchasePrice;
  String? unitPrice;
  String? salePrice;
  String? quantity;
  String? subtotal;
  String? createdAt;
  String? updatedAt;
  ProductDetail? productDetail;

  SaleDetail({
    this.id,
    this.saleId,
    this.productId,
    this.productDetailsId,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.purchasePrice,
    this.unitPrice,
    this.salePrice,
    this.quantity,
    this.subtotal,
    this.createdAt,
    this.updatedAt,
    this.productDetail,
  });

  factory SaleDetail.fromJson(Map<String, dynamic> json) => SaleDetail(
        id: json["id"]?.toString() ?? "",
        saleId: json["sale_id"]?.toString() ?? "",
        productId: json["product_id"]?.toString() ?? "",
        productDetailsId: json["product_details_id"]?.toString() ?? "",
        taxId: json["tax_id"]?.toString() ?? "",
        taxType: json["tax_type"]?.toString() ?? "",
        taxAmount: json["tax_amount"]?.toString() ?? "",
        taxPercentage: json["tax_percentage"]?.toString() ?? "",
        discountType: json["discount_type"]?.toString() ?? "",
        discountValue: json["discount_value"]?.toString() ?? "",
        discountAmount: json["discount_amount"]?.toString() ?? "",
        purchasePrice: json["purchase_price"]?.toString() ?? "",
        unitPrice: json["unit_price"]?.toString() ?? "",
        salePrice: json["sale_price"]?.toString() ?? "",
        quantity: json["quantity"]?.toString() ?? "",
        subtotal: json["subtotal"]?.toString() ?? "",
        createdAt: json["created_at"]?.toString() ?? "",
        updatedAt: json["updated_at"]?.toString() ?? "",
        productDetail: json["product_detail"] == null
            ? null
            : ProductDetail.fromJson(json["product_detail"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "sale_id": saleId,
        "product_id": productId,
        "product_details_id": productDetailsId,
        "tax_id": taxId,
        "tax_type": taxType,
        "tax_amount": taxAmount,
        "tax_percentage": taxPercentage,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "purchase_price": purchasePrice,
        "unit_price": unitPrice,
        "sale_price": salePrice,
        "quantity": quantity,
        "subtotal": subtotal,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "product_detail": productDetail?.toJson(),
      };
}

class ProductDetail {
  String? id;
  String? productId;
  String? sku;
  String? basePrice;
  String? taxId;
  String? taxType;
  String? taxAmount;
  String? taxPercentage;
  String? purchasePrice;
  String? profitMargin;
  String? salePrice;
  String? discountType;
  String? discountValue;
  String? discountAmount;
  String? finalPrice;
  String? alertQuantity;
  String? variantId;
  String? attributeId;
  String? createdAt;
  String? updatedAt;
  Product? product;

  ProductDetail({
    this.id,
    this.productId,
    this.sku,
    this.basePrice,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.purchasePrice,
    this.profitMargin,
    this.salePrice,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.finalPrice,
    this.alertQuantity,
    this.variantId,
    this.attributeId,
    this.createdAt,
    this.updatedAt,
    this.product,
  });

  factory ProductDetail.fromJson(Map<String, dynamic> json) => ProductDetail(
        id: json["id"]?.toString() ?? "",
        productId: json["product_id"]?.toString() ?? "",
        sku: json["sku"]?.toString() ?? "",
        basePrice: json["base_price"]?.toString() ?? "",
        taxId: json["tax_id"]?.toString() ?? "",
        taxType: json["tax_type"]?.toString() ?? "",
        taxAmount: json["tax_amount"]?.toString() ?? "",
        taxPercentage: json["tax_percentage"]?.toString() ?? "",
        purchasePrice: json["purchase_price"]?.toString() ?? "",
        profitMargin: json["profit_margin"]?.toString() ?? "",
        salePrice: json["sale_price"]?.toString() ?? "",
        discountType: json["discount_type"]?.toString() ?? "",
        discountValue: json["discount_value"]?.toString() ?? "",
        discountAmount: json["discount_amount"]?.toString() ?? "",
        finalPrice: json["final_price"]?.toString() ?? "",
        alertQuantity: json["alert_quantity"]?.toString() ?? "",
        variantId: json["variant_id"]?.toString() ?? "",
        attributeId: json["attribute_id"]?.toString() ?? "",
        createdAt: json["created_at"]?.toString() ?? "",
        updatedAt: json["updated_at"]?.toString() ?? "",
        product:
            json["product"] == null ? null : Product.fromJson(json["product"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "product_id": productId,
        "sku": sku,
        "base_price": basePrice,
        "tax_id": taxId,
        "tax_type": taxType,
        "tax_amount": taxAmount,
        "tax_percentage": taxPercentage,
        "purchase_price": purchasePrice,
        "profit_margin": profitMargin,
        "sale_price": salePrice,
        "discount_type": discountType,
        "discount_value": discountValue,
        "discount_amount": discountAmount,
        "final_price": finalPrice,
        "alert_quantity": alertQuantity,
        "variant_id": variantId,
        "attribute_id": attributeId,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "product": product?.toJson(),
      };
}

class Product {
  String? id;
  String? name;
  String? productCode;
  String? productType;
  String? categoryId;
  String? unitId;
  String? brandId;
  String? image;
  String? description;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;
  String? imageSrc;

  Product({
    this.id,
    this.name,
    this.productCode,
    this.productType,
    this.categoryId,
    this.unitId,
    this.brandId,
    this.image,
    this.description,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
  });

  factory Product.fromJson(Map<String, dynamic> json) => Product(
        id: json["id"]?.toString() ?? "",
        name: json["name"]?.toString() ?? "",
        productCode: json["product_code"]?.toString() ?? "",
        productType: json["product_type"]?.toString() ?? "",
        categoryId: json["category_id"]?.toString() ?? "",
        unitId: json["unit_id"]?.toString() ?? "",
        brandId: json["brand_id"]?.toString() ?? "",
        image: json["image"]?.toString() ?? "",
        description: json["description"]?.toString() ?? "",
        status: json["status"]?.toString() ?? "",
        deletedAt: json["deleted_at"]?.toString() ?? "",
        createdAt: json["created_at"]?.toString() ?? "",
        updatedAt: json["updated_at"]?.toString() ?? "",
        imageSrc: json["image_src"]?.toString() ?? "",
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "product_code": productCode,
        "product_type": productType,
        "category_id": categoryId,
        "unit_id": unitId,
        "brand_id": brandId,
        "image": image,
        "description": description,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "image_src": imageSrc,
      };
}

class Customer {
  String? id;
  String? name;
  String? email;
  String? mobile;
  String? address;
  String? city;
  String? state;
  String? country;
  String? zip;
  String? postcode;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  Customer({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Customer.fromJson(Map<String, dynamic> json) => Customer(
        id: json["id"].toString(),
        name: json["name"].toString(),
        email: json["email"].toString(),
        mobile: json["mobile"].toString(),
        address: json["address"]?.toString() ?? "",
        city: json["city"].toString(),
        state: json["state"].toString(),
        country: json["country"].toString(),
        zip: json["zip"].toString(),
        postcode: json["postcode"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "email": email,
        "mobile": mobile,
        "address": address,
        "city": city,
        "state": state,
        "country": country,
        "zip": zip,
        "postcode": postcode,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Payment {
  String? id;
  String? saleId;
  String? customerId;
  String? paymentType;
  String? amount;
  String? note;
  String? date;
  String? createdAt;
  String? updatedAt;

  Payment({
    this.id,
    this.saleId,
    this.customerId,
    this.paymentType,
    this.amount,
    this.note,
    this.date,
    this.createdAt,
    this.updatedAt,
  });

  factory Payment.fromJson(Map<String, dynamic> json) => Payment(
        id: json["id"].toString(),
        saleId: json["sale_id"].toString(),
        customerId: json["customer_id"].toString(),
        paymentType: json["payment_type"].toString(),
        amount: json["amount"].toString(),
        note: json["note"].toString(),
        date: json["date"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "sale_id": saleId,
        "customer_id": customerId,
        "payment_type": paymentType,
        "amount": amount,
        "note": note,
        "date": date,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Warehouse {
  String? id;
  String? name;
  String? address;
  String? city;
  String? state;
  String? postcode;
  String? contactNumber;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  Warehouse({
    this.id,
    this.name,
    this.address,
    this.city,
    this.state,
    this.postcode,
    this.contactNumber,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Warehouse.fromJson(Map<String, dynamic> json) => Warehouse(
        id: json["id"].toString(),
        name: json["name"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        postcode: json["postcode"].toString(),
        contactNumber: json["contact_number"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "address": address,
        "city": city,
        "state": state,
        "postcode": postcode,
        "contact_number": contactNumber,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
