import 'dart:convert';

PaymentMethodUpdateResponseModel paymentMethodResponseModelFromJson(
        String str) =>
    PaymentMethodUpdateResponseModel.fromJson(json.decode(str));
String paymentMethodResponseModelToJson(
        PaymentMethodUpdateResponseModel data) =>
    json.encode(data.toJson());

class PaymentMethodUpdateResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;
  PaymentMethodUpdateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });
  factory PaymentMethodUpdateResponseModel.fromJson(
          Map<String, dynamic> json) =>
      PaymentMethodUpdateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final PaymentTypes? paymentTypes;
  Data({
    this.paymentTypes,
  });
  factory Data.fromJson(Map<String, dynamic> json) => Data(
        paymentTypes: json["paymentTypes"] == null
            ? null
            : PaymentTypes.fromJson(json["paymentTypes"]),
      );
  Map<String, dynamic> toJson() => {
        "paymentTypes": paymentTypes?.toJson(),
      };
}

class PaymentTypes {
  final String? currentPage;
  final List<PaymentMethodData>? data;
  final String? firstPageUrl;
  final String? from;
  final String? lastPage;
  final String? lastPageUrl;
  final List<Link>? links;
  final String? nextPageUrl;
  final String? path;
  final String? perPage;
  final String? prevPageUrl;
  final String? to;
  final String? total;
  PaymentTypes({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.links,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });
  factory PaymentTypes.fromJson(Map<String, dynamic> json) => PaymentTypes(
        currentPage: json["current_page"].toString(),
        data: json["data"] == null
            ? []
            : List<PaymentMethodData>.from(
                json["data"]!.map((x) => PaymentMethodData.fromJson(x))),
        firstPageUrl: json["first_page_url"].toString(),
        from: json["from"].toString(),
        lastPage: json["last_page"].toString(),
        lastPageUrl: json["last_page_url"].toString(),
        links: json["links"] == null
            ? []
            : List<Link>.from(json["links"]!.map((x) => Link.fromJson(x))),
        nextPageUrl: json["next_page_url"].toString(),
        path: json["path"].toString(),
        perPage: json["per_page"].toString(),
        prevPageUrl: json["prev_page_url"].toString(),
        to: json["to"].toString(),
        total: json["total"].toString(),
      );
  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "links": links == null
            ? []
            : List<dynamic>.from(links!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class PaymentMethodData {
  String? id;
  String? name;
  String? status;
  String? isDefault;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;
  PaymentMethodData({
    this.id,
    this.name,
    this.status,
    this.isDefault,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });
  factory PaymentMethodData.fromJson(Map<String, dynamic> json) =>
      PaymentMethodData(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        isDefault: json["is_default"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );
  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "is_default": isDefault,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Link {
  final String? url;
  final String? label;
  final bool? active;
  Link({
    this.url,
    this.label,
    this.active,
  });
  factory Link.fromJson(Map<String, dynamic> json) => Link(
        url: json["url"].toString(),
        label: json["label"].toString(),
        active: json["active"],
      );
  Map<String, dynamic> toJson() => {
        "url": url,
        "label": label,
        "active": active,
      };
}
