// To parse this JSON data, do
//
//     final paymentMethodStatusResponseModel = paymentMethodStatusResponseModelFromJson(jsonString);

import 'dart:convert';

PaymentMethodStatusResponseModel paymentMethodStatusResponseModelFromJson(
        String str) =>
    PaymentMethodStatusResponseModel.fromJson(json.decode(str));

String paymentMethodStatusResponseModelToJson(
        PaymentMethodStatusResponseModel data) =>
    json.encode(data.toJson());

class PaymentMethodStatusResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  PaymentMethodStatusResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory PaymentMethodStatusResponseModel.fromJson(
          Map<String, dynamic> json) =>
      PaymentMethodStatusResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Paymenttype? paymenttype;

  Data({
    this.paymenttype,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        paymenttype: json["paymenttype"] == null
            ? null
            : Paymenttype.fromJson(json["paymenttype"]),
      );

  Map<String, dynamic> toJson() => {
        "paymenttype": paymenttype?.toJson(),
      };
}

class Paymenttype {
  final String? id;
  final String? name;
  final String? status;
  final String? isDefault;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Paymenttype({
    this.id,
    this.name,
    this.status,
    this.isDefault,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Paymenttype.fromJson(Map<String, dynamic> json) => Paymenttype(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        isDefault: json["is_default"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "is_default": isDefault,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
