// To parse this JSON data, do
//
//     final paymentMethodResponseModel = paymentMethodResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:ovosale/data/model/payment_method/payment_account_resonse_model.dart';

PaymentMethodResponseModel paymentMethodResponseModelFromJson(String str) =>
    PaymentMethodResponseModel.fromJson(json.decode(str));

class PaymentMethodResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  PaymentMethodResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory PaymentMethodResponseModel.fromJson(Map<String, dynamic> json) =>
      PaymentMethodResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final List<PaymentMethod>? paymentMethods;

  Data({
    this.paymentMethods,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        paymentMethods: json["payment_methods"] == null
            ? []
            : List<PaymentMethod>.from(
                json["payment_methods"]!.map((x) => PaymentMethod.fromJson(x))),
      );
}

class PaymentMethod {
  final int? id;
  final String? name;
  final String? status;
  final String? isDefault;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  List<PaymentAccountModel>? paymentAccounts;
  PaymentMethod({
    this.id,
    this.name,
    this.status,
    this.isDefault,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.paymentAccounts,
  });

  factory PaymentMethod.fromJson(Map<String, dynamic> json) => PaymentMethod(
        id: json["id"],
        name: json["name"]?.toString(),
        status: json["status"]?.toString(),
        isDefault: json["is_default"]?.toString(),
        deletedAt: json["deleted_at"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        paymentAccounts: json["payment_accounts"] == null
            ? []
            : List<PaymentAccountModel>.from(json["payment_accounts"]!
                .map((x) => PaymentAccountModel.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "is_default": isDefault,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "payment_accounts": paymentAccounts == null
            ? []
            : List<dynamic>.from(paymentAccounts!.map((x) => x.toJson())),
      };
}
