// To parse this JSON data, do
//
//     final paymentAccountsResponseModel = paymentAccountsResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:ovosale/data/model/payment_method/payment_method_response_model.dart';

PaymentAccountsResponseModel paymentAccountsResponseModelFromJson(String str) =>
    PaymentAccountsResponseModel.fromJson(json.decode(str));

String paymentAccountsResponseModelToJson(PaymentAccountsResponseModel data) =>
    json.encode(data.toJson());

class PaymentAccountsResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  PaymentAccountsResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory PaymentAccountsResponseModel.fromJson(Map<String, dynamic> json) =>
      PaymentAccountsResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  PaymentAccounts? paymentAccounts;
  List<PaymentMethod>? paymentTypes;

  Data({
    this.paymentAccounts,
    this.paymentTypes,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        paymentAccounts: json["paymentAccounts"] == null
            ? null
            : PaymentAccounts.fromJson(json["paymentAccounts"]),
        paymentTypes: json["paymentTypes"] == null
            ? []
            : List<PaymentMethod>.from(
                json["paymentTypes"]!.map((x) => PaymentMethod.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "paymentAccounts": paymentAccounts?.toJson(),
        "paymentTypes": paymentTypes == null
            ? []
            : List<dynamic>.from(paymentTypes!.map((x) => x.toJson())),
      };
}

class PaymentAccounts {
  String? currentPage;
  List<PaymentAccountModel>? data;
  String? firstPageUrl;
  String? lastPageUrl;
  String? nextPageUrl;
  String? path;
  String? perPage;
  String? to;
  String? total;

  PaymentAccounts({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.lastPageUrl,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.to,
    this.total,
  });

  factory PaymentAccounts.fromJson(Map<String, dynamic> json) =>
      PaymentAccounts(
        currentPage: json["current_page"]?.toString(),
        data: json["data"] == null
            ? []
            : List<PaymentAccountModel>.from(
                json["data"]!.map((x) => PaymentAccountModel.fromJson(x))),
        firstPageUrl: json["first_page_url"]?.toString(),
        lastPageUrl: json["last_page_url"]?.toString(),
        nextPageUrl: json["next_page_url"]?.toString(),
        path: json["path"]?.toString(),
        perPage: json["per_page"]?.toString(),
        to: json["to"]?.toString(),
        total: json["total"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "last_page_url": lastPageUrl,
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "to": to,
        "total": total,
      };
}

class PaymentAccountModel {
  int? id;
  int? paymentTypeId;
  String? accountName;
  String? accountNumber;
  String? balance;
  String? note;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;
  PaymentMethod? paymentType;

  PaymentAccountModel({
    this.id,
    this.paymentTypeId,
    this.accountName,
    this.accountNumber,
    this.balance,
    this.note,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.paymentType,
  });

  factory PaymentAccountModel.fromJson(Map<String, dynamic> json) =>
      PaymentAccountModel(
        id: json["id"],
        paymentTypeId: json["payment_type_id"],
        accountName: json["account_name"]?.toString(),
        accountNumber: json["account_number"]?.toString(),
        balance: json["balance"]?.toString(),
        note: json["note"]?.toString(),
        status: json["status"]?.toString(),
        deletedAt: json["deleted_at"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        paymentType: json["payment_type"] == null
            ? null
            : PaymentMethod.fromJson(json["payment_type"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "payment_type_id": paymentTypeId,
        "account_name": accountName,
        "account_number": accountNumber,
        "balance": balance,
        "note": note,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "payment_type": paymentType?.toJson(),
      };
}
