// To parse this JSON data, do
//
//     final newPaymentMethodResponseModel = newPaymentMethodResponseModelFromJson(jsonString);

import 'dart:convert';

NewPaymentMethodResponseModel newPaymentMethodResponseModelFromJson(
        String str) =>
    NewPaymentMethodResponseModel.fromJson(json.decode(str));

String newPaymentMethodResponseModelToJson(
        NewPaymentMethodResponseModel data) =>
    json.encode(data.toJson());

class NewPaymentMethodResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  NewPaymentMethodResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory NewPaymentMethodResponseModel.fromJson(Map<String, dynamic> json) =>
      NewPaymentMethodResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  PaymentType? paymentType;

  Data({
    this.paymentType,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        paymentType: json["paymentType"] == null
            ? null
            : PaymentType.fromJson(json["paymentType"]),
      );

  Map<String, dynamic> toJson() => {
        "paymentType": paymentType?.toJson(),
      };
}

class PaymentType {
  String? name;
  String? updatedAt;
  String? createdAt;
  String? id;

  PaymentType({
    this.name,
    this.updatedAt,
    this.createdAt,
    this.id,
  });

  factory PaymentType.fromJson(Map<String, dynamic> json) => PaymentType(
        name: json["name"]?.toString() ?? "",
        updatedAt: json["updated_at"]?.toString() ?? "",
        createdAt: json["created_at"]?.toString() ?? "",
        id: json["id"]?.toString() ?? "",
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
      };
}
