// To parse this JSON data, do
//
//     final requiredDataResponseModel = requiredDataResponseModelFromJson(jsonString);

import 'dart:convert';

RequiredDataResponseModel requiredDataResponseModelFromJson(String str) =>
    RequiredDataResponseModel.fromJson(json.decode(str));

class RequiredDataResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  RequiredDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory RequiredDataResponseModel.fromJson(Map<String, dynamic> json) =>
      RequiredDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final List<Category>? categories;
  final List<Warehouse>? warehouses;

  Data({
    this.categories,
    this.warehouses,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        categories: json["categories"] == null
            ? []
            : List<Category>.from(
                json["categories"]!.map((x) => Category.fromJson(x))),
        warehouses: json["warehouses"] == null
            ? []
            : List<Warehouse>.from(
                json["warehouses"]!.map((x) => Warehouse.fromJson(x))),
      );
}

class Category {
  final int? id;
  final String? name;
  final int? status;
  final String? image;
  final dynamic deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? imageSrc;
  final String? shortName;
  final int? attributeId;
  bool isSelected;

  Category({
    this.id,
    this.name,
    this.status,
    this.image,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
    this.shortName,
    this.attributeId,
    this.isSelected = false,
  });

  factory Category.fromJson(Map<String, dynamic> json) => Category(
        id: json["id"],
        name: json["name"] != null ? json["name"].toString() : "",
        status: json["status"],
        image: json["image"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        imageSrc: json["image_src"] != null ? json["image_src"].toString() : "",
        shortName: json["short_name"],
        attributeId: json["attribute_id"],
      );
}

class Warehouse {
  final int? id;
  final String? name;
  final String? address;
  final String? city;
  final String? state;
  final String? postcode;
  final String? contactNumber;
  final int? status;
  final dynamic deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Warehouse({
    this.id,
    this.name,
    this.address,
    this.city,
    this.state,
    this.postcode,
    this.contactNumber,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Warehouse.fromJson(Map<String, dynamic> json) => Warehouse(
        id: json["id"],
        name: json["name"],
        address: json["address"],
        city: json["city"],
        state: json["state"],
        postcode: json["postcode"],
        contactNumber: json["contact_number"],
        status: json["status"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );
}
