// To parse this JSON data, do
//
//     final newSaleResponseModel = newSaleResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:flutter/cupertino.dart';
import 'package:ovosale/data/model/new_sale/required_data_response_model.dart';

NewSaleResponseModel newSaleResponseModelFromJson(String str) =>
    NewSaleResponseModel.fromJson(json.decode(str));

class NewSaleResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  NewSaleResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory NewSaleResponseModel.fromJson(Map<String, dynamic> json) =>
      NewSaleResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final List<SaleProduct>? products;
  String? hasMore;
  Data({
    this.products,
    this.hasMore,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        products: json["products"] == null
            ? []
            : List<SaleProduct>.from(
                json["products"]!.map((x) => SaleProduct.fromJson(x))),
        hasMore: json["hasMore"]?.toString(),
      );
}

class SaleProduct {
  final int? id;
  final String? cardId;
  final String? name;
  final String? sku;
  final String? productType;
  final String? imageSrc;
  final String? attributeName;
  final String? variantName;
  final String? inStock;
  final String? unitName;
  final String? price;
  final String? quantity;
  final Original? original;
  TextEditingController? quantityController;
  int finalQuantity;
  bool isLoading;

  SaleProduct(
      {this.id,
      this.cardId,
      this.name,
      this.sku,
      this.productType,
      this.imageSrc,
      this.attributeName,
      this.variantName,
      this.inStock,
      this.unitName,
      this.price,
      this.original,
      this.quantityController,
      this.quantity,
      this.finalQuantity = 1,
      this.isLoading = false}) {
    quantityController ??= TextEditingController();
  }

  factory SaleProduct.fromJson(Map<String, dynamic> json) => SaleProduct(
        id: json["id"],
        cardId: json["cart_id"] != null ? json["cart_id"].toString() : "",
        name: json["name"] != null ? json["name"].toString() : "",
        sku: json["sku"] != null ? json["sku"].toString() : "",
        productType:
            json["product_type"] != null ? json["product_type"].toString() : "",
        imageSrc: json["image_src"] != null ? json["image_src"].toString() : "",
        attributeName: json["attribute_name"] != null
            ? json["attribute_name"].toString()
            : "",
        variantName:
            json["variant_name"] != null ? json["variant_name"].toString() : "",
        inStock: json["in_stock"] != null ? json["in_stock"].toString() : "",
        unitName: json["unit_name"] != null ? json["unit_name"].toString() : "",
        price: json["price"] != null ? json["price"].toString() : "",
        quantity: json["quantity"] != null ? json["quantity"].toString() : "",
        original: json["original"] == null
            ? null
            : Original.fromJson(json["original"]),
      );
}

class Original {
  final int? id;
  final int? productId;
  final String? sku;
  final String? basePrice;
  final int? taxId;
  final int? taxType;
  final String? taxAmount;
  final String? taxPercentage;
  final String? purchasePrice;
  final String? profitMargin;
  final String? salePrice;
  final int? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? finalPrice;
  final String? alertQuantity;
  final int? variantId;
  final int? attributeId;
  final dynamic createdAt;
  final String? updatedAt;
  final dynamic productStockSumStock;
  final OriginalProduct? product;

  Original({
    this.id,
    this.productId,
    this.sku,
    this.basePrice,
    this.taxId,
    this.taxType,
    this.taxAmount,
    this.taxPercentage,
    this.purchasePrice,
    this.profitMargin,
    this.salePrice,
    this.discountType,
    this.discountValue,
    this.discountAmount,
    this.finalPrice,
    this.alertQuantity,
    this.variantId,
    this.attributeId,
    this.createdAt,
    this.updatedAt,
    this.productStockSumStock,
    this.product,
  });

  factory Original.fromJson(Map<String, dynamic> json) => Original(
        id: json["id"],
        productId: json["product_id"],
        sku: json["sku"],
        basePrice: json["base_price"],
        taxId: json["tax_id"],
        taxType: json["tax_type"],
        taxAmount: json["tax_amount"],
        taxPercentage: json["tax_percentage"],
        purchasePrice: json["purchase_price"],
        profitMargin: json["profit_margin"],
        salePrice: json["sale_price"],
        discountType: json["discount_type"],
        discountValue: json["discount_value"],
        discountAmount: json["discount_amount"],
        finalPrice: json["final_price"],
        alertQuantity: json["alert_quantity"],
        variantId: json["variant_id"],
        attributeId: json["attribute_id"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        productStockSumStock: json["product_stock_sum_stock"],
        product: json["product"] == null
            ? null
            : OriginalProduct.fromJson(json["product"]),
      );
}

class OriginalProduct {
  final int? id;
  final String? name;
  final String? productCode;
  final int? productType;
  final int? categoryId;
  final int? unitId;
  final int? brandId;
  final String? image;
  final String? description;
  final int? status;
  final dynamic deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? imageSrc;
  final Category? unit;

  OriginalProduct({
    this.id,
    this.name,
    this.productCode,
    this.productType,
    this.categoryId,
    this.unitId,
    this.brandId,
    this.image,
    this.description,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
    this.unit,
  });

  factory OriginalProduct.fromJson(Map<String, dynamic> json) =>
      OriginalProduct(
        id: json["id"],
        name: json["name"],
        productCode: json["product_code"],
        productType: json["product_type"],
        categoryId: json["category_id"],
        unitId: json["unit_id"],
        brandId: json["brand_id"],
        image: json["image"],
        description: json["description"],
        status: json["status"],
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        imageSrc: json["image_src"],
        unit: json["unit"] == null ? null : Category.fromJson(json["unit"]),
      );
}
