// To parse this JSON data, do
//
//     final confirmSaleResponseModel = confirmSaleResponseModelFromJson(jsonString);

import 'dart:convert';

import '../payment_method/view_sale_response_model.dart';

ConfirmSaleResponseModel confirmSaleResponseModelFromJson(String str) => ConfirmSaleResponseModel.fromJson(json.decode(str));

class ConfirmSaleResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  ConfirmSaleResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ConfirmSaleResponseModel.fromJson(Map<String, dynamic> json) => ConfirmSaleResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? [] : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final String? html;
  final SaleDataModel? sale;
  CompanyInformation? companyInformation;
  Data({
    this.html,
    this.sale,
    this.companyInformation,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        html: json["html"],
        sale: json["sale"] == null ? null : SaleDataModel.fromJson(json["sale"]),
        companyInformation: json["companyInformation"] == null ? null : CompanyInformation.fromJson(json["companyInformation"]),
      );
}
