// To parse this JSON data, do
//
//     final expenseDataResponseModel = expenseDataResponseModelFromJson(jsonString);

import 'dart:convert';

ExpenseDataResponseModel expenseDataResponseModelFromJson(String str) =>
    ExpenseDataResponseModel.fromJson(json.decode(str));

String expenseDataResponseModelToJson(ExpenseDataResponseModel data) =>
    json.encode(data.toJson());

class ExpenseDataResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  ExpenseDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ExpenseDataResponseModel.fromJson(Map<String, dynamic> json) =>
      ExpenseDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Expenses? expenses;
  final Widget? widget;

  Data({
    this.expenses,
    this.widget,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        expenses: json["expenses"] == null
            ? null
            : Expenses.fromJson(json["expenses"]),
        widget: json["widget"] == null ? null : Widget.fromJson(json["widget"]),
      );

  Map<String, dynamic> toJson() => {
        "expenses": expenses?.toJson(),
        "widget": widget?.toJson(),
      };
}

class Expenses {
  final String? currentPage;
  final List<ExpenseListData>? data;
  final String? firstPageUrl;
  final String? from;
  final String? lastPage;
  final String? lastPageUrl;
  final List<Link>? links;
  final String? nextPageUrl;
  final String? path;
  final String? perPage;
  final String? prevPageUrl;
  final String? to;
  final String? total;

  Expenses({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.links,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory Expenses.fromJson(Map<String, dynamic> json) => Expenses(
        currentPage: json["current_page"].toString(),
        data: json["data"] == null
            ? []
            : List<ExpenseListData>.from(
                json["data"]!.map((x) => ExpenseListData.fromJson(x))),
        firstPageUrl: json["first_page_url"].toString(),
        from: json["from"].toString(),
        lastPage: json["last_page"].toString(),
        lastPageUrl: json["last_page_url"].toString(),
        links: json["links"] == null
            ? []
            : List<Link>.from(json["links"]!.map((x) => Link.fromJson(x))),
        nextPageUrl: json["next_page_url"].toString(),
        path: json["path"].toString(),
        perPage: json["per_page"].toString(),
        prevPageUrl: json["prev_page_url"].toString(),
        to: json["to"].toString(),
        total: json["total"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "links": links == null
            ? []
            : List<dynamic>.from(links!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class ExpenseListData {
  final String? id;
  final String? categoryId;
  final String? addedBy;
  final String? expenseDate;
  final String? referenceNo;
  final String? comment;
  final String? amount;
  final String? attachment;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  ExpenseListData({
    this.id,
    this.categoryId,
    this.addedBy,
    this.expenseDate,
    this.referenceNo,
    this.comment,
    this.amount,
    this.attachment,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory ExpenseListData.fromJson(Map<String, dynamic> json) =>
      ExpenseListData(
        id: json["id"].toString(),
        categoryId: json["category_id"].toString(),
        addedBy: json["added_by"].toString(),
        expenseDate: json["expense_date"].toString(),
        referenceNo: json["reference_no"].toString(),
        comment: json["comment"].toString(),
        amount: json["amount"].toString(),
        attachment: json["attachment"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "category_id": categoryId,
        "added_by": addedBy,
        "expense_date": expenseDate,
        "reference_no": referenceNo,
        "comment": comment,
        "amount": amount,
        "attachment": attachment,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Link {
  final String? url;
  final String? label;
  final bool? active;

  Link({
    this.url,
    this.label,
    this.active,
  });

  factory Link.fromJson(Map<String, dynamic> json) => Link(
        url: json["url"].toString(),
        label: json["label"].toString(),
        active: json["active"],
      );

  Map<String, dynamic> toJson() => {
        "url": url,
        "label": label,
        "active": active,
      };
}

class Widget {
  final String? todayExpense;
  final String? yesterdayExpense;
  final String? thisWeekExpense;
  final String? last7DaysWeekExpense;
  final String? thisMonthExpense;
  final String? last30DaysMonthExpense;
  final String? allExpense;
  final String? lastExpenseAmount;

  Widget({
    this.todayExpense,
    this.yesterdayExpense,
    this.thisWeekExpense,
    this.last7DaysWeekExpense,
    this.thisMonthExpense,
    this.last30DaysMonthExpense,
    this.allExpense,
    this.lastExpenseAmount,
  });

  factory Widget.fromJson(Map<String, dynamic> json) => Widget(
        todayExpense: json["today_expense"].toString(),
        yesterdayExpense: json["yesterday_expense"].toString(),
        thisWeekExpense: json["this_week_expense"].toString(),
        last7DaysWeekExpense: json["last_7days_week_expense"].toString(),
        thisMonthExpense: json["this_month_expense"].toString(),
        last30DaysMonthExpense: json["last_30days_month_expense"].toString(),
        allExpense: json["all_expense"].toString(),
        lastExpenseAmount: json["last_expense_amount"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "today_expense": todayExpense,
        "yesterday_expense": yesterdayExpense,
        "this_week_expense": thisWeekExpense,
        "last_7days_week_expense": last7DaysWeekExpense,
        "this_month_expense": thisMonthExpense,
        "last_30days_month_expense": last30DaysMonthExpense,
        "all_expense": allExpense,
        "last_expense_amount": lastExpenseAmount,
      };
}
