// To parse this JSON data, do
//
//     final expenseCategoryUpdateResponseModel = expenseCategoryUpdateResponseModelFromJson(jsonString);

import 'dart:convert';

ExpenseCategoryUpdateResponseModel expenseCategoryUpdateResponseModelFromJson(
        String str) =>
    ExpenseCategoryUpdateResponseModel.fromJson(json.decode(str));

String expenseCategoryUpdateResponseModelToJson(
        ExpenseCategoryUpdateResponseModel data) =>
    json.encode(data.toJson());

class ExpenseCategoryUpdateResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  ExpenseCategoryUpdateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ExpenseCategoryUpdateResponseModel.fromJson(
          Map<String, dynamic> json) =>
      ExpenseCategoryUpdateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final ExpenseCategory? expenseCategory;

  Data({
    this.expenseCategory,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        expenseCategory: json["expenseCategory"] == null
            ? null
            : ExpenseCategory.fromJson(json["expenseCategory"]),
      );

  Map<String, dynamic> toJson() => {
        "expenseCategory": expenseCategory?.toJson(),
      };
}

class ExpenseCategory {
  final String? id;
  final String? name;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final String? deletedAt;

  ExpenseCategory({
    this.id,
    this.name,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
  });

  factory ExpenseCategory.fromJson(Map<String, dynamic> json) =>
      ExpenseCategory(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        deletedAt: json["deleted_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "deleted_at": deletedAt,
      };
}
