import 'dart:convert';

ExpenseCategoryResponseModel expenseCategoryResponseModelFromJson(String str) =>
    ExpenseCategoryResponseModel.fromJson(json.decode(str));

String expenseCategoryResponseModelToJson(ExpenseCategoryResponseModel data) =>
    json.encode(data.toJson());

class ExpenseCategoryResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  ExpenseCategoryResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ExpenseCategoryResponseModel.fromJson(Map<String, dynamic> json) =>
      ExpenseCategoryResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  ExpenseCategories? expenseCategories;

  Data({
    this.expenseCategories,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        expenseCategories: json["expenseCategories"] == null
            ? null
            : ExpenseCategories.fromJson(json["expenseCategories"]),
      );

  Map<String, dynamic> toJson() => {
        "expenseCategories": expenseCategories?.toJson(),
      };
}

class ExpenseCategories {
  String? currentPage;
  List<ExpenseData>? data;
  String? firstPageUrl;
  String? from;
  String? lastPage;
  String? lastPageUrl;
  List<Link>? links;
  String? nextPageUrl;
  String? path;
  String? perPage;
  String? prevPageUrl;
  String? to;
  String? total;

  ExpenseCategories({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.links,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory ExpenseCategories.fromJson(Map<String, dynamic> json) =>
      ExpenseCategories(
        currentPage: json["current_page"].toString(),
        data: json["data"] == null
            ? []
            : List<ExpenseData>.from(
                json["data"]!.map((x) => ExpenseData.fromJson(x))),
        firstPageUrl: json["first_page_url"].toString(),
        from: json["from"].toString(),
        lastPage: json["last_page"].toString(),
        lastPageUrl: json["last_page_url"].toString(),
        links: json["links"] == null
            ? []
            : List<Link>.from(json["links"]!.map((x) => Link.fromJson(x))),
        nextPageUrl: json["next_page_url"].toString(),
        path: json["path"].toString(),
        perPage: json["per_page"].toString(),
        prevPageUrl: json["prev_page_url"].toString(),
        to: json["to"].toString(),
        total: json["total"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "links": links == null
            ? []
            : List<dynamic>.from(links!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class ExpenseData {
  String? id;
  String? name;
  String? status;
  String? createdAt;
  String? updatedAt;
  String? deletedAt;

  ExpenseData({
    this.id,
    this.name,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
  });

  factory ExpenseData.fromJson(Map<String, dynamic> json) => ExpenseData(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        deletedAt: json["deleted_at"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "deleted_at": deletedAt,
      };
}

class Link {
  String? url;
  String? label;
  bool? active;

  Link({
    this.url,
    this.label,
    this.active,
  });

  factory Link.fromJson(Map<String, dynamic> json) => Link(
        url: json["url"].toString(),
        label: json["label"].toString(),
        active: json["active"],
      );

  Map<String, dynamic> toJson() => {
        "url": url,
        "label": label,
        "active": active,
      };
}
