// To parse this JSON data, do
//
//     final expenseCategoryStatusDataResponseModel = expenseCategoryStatusDataResponseModelFromJson(jsonString);

import 'dart:convert';

ExpenseCategoryStatusDataResponseModel
    expenseCategoryStatusDataResponseModelFromJson(String str) =>
        ExpenseCategoryStatusDataResponseModel.fromJson(json.decode(str));

String expenseCategoryStatusDataResponseModelToJson(
        ExpenseCategoryStatusDataResponseModel data) =>
    json.encode(data.toJson());

class ExpenseCategoryStatusDataResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  ExpenseCategoryStatusDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory ExpenseCategoryStatusDataResponseModel.fromJson(
          Map<String, dynamic> json) =>
      ExpenseCategoryStatusDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Expensecategory? expensecategory;

  Data({
    this.expensecategory,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        expensecategory: json["expensecategory"] == null
            ? null
            : Expensecategory.fromJson(json["expensecategory"]),
      );

  Map<String, dynamic> toJson() => {
        "expensecategory": expensecategory?.toJson(),
      };
}

class Expensecategory {
  final String? id;
  final String? name;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final String? deletedAt;

  Expensecategory({
    this.id,
    this.name,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
  });

  factory Expensecategory.fromJson(Map<String, dynamic> json) =>
      Expensecategory(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        deletedAt: json["deleted_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "deleted_at": deletedAt,
      };
}
