// To parse this JSON data, do
//
//     final createExpenseCategoryResponseModel = createExpenseCategoryResponseModelFromJson(jsonString);

import 'dart:convert';

CreateExpenseCategoryResponseModel createExpenseCategoryResponseModelFromJson(
        String str) =>
    CreateExpenseCategoryResponseModel.fromJson(json.decode(str));

String createExpenseCategoryResponseModelToJson(
        CreateExpenseCategoryResponseModel data) =>
    json.encode(data.toJson());

class CreateExpenseCategoryResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  CreateExpenseCategoryResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CreateExpenseCategoryResponseModel.fromJson(
          Map<String, dynamic> json) =>
      CreateExpenseCategoryResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final ExpenseCategory? expenseCategory;

  Data({
    this.expenseCategory,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        expenseCategory: json["expenseCategory"] == null
            ? null
            : ExpenseCategory.fromJson(json["expenseCategory"]),
      );

  Map<String, dynamic> toJson() => {
        "expenseCategory": expenseCategory?.toJson(),
      };
}

class ExpenseCategory {
  final String? name;
  final String? updatedAt;
  final String? createdAt;
  final String? id;

  ExpenseCategory({
    this.name,
    this.updatedAt,
    this.createdAt,
    this.id,
  });

  factory ExpenseCategory.fromJson(Map<String, dynamic> json) =>
      ExpenseCategory(
        name: json["name"].toString(),
        updatedAt: json["updated_at"].toString(),
        createdAt: json["created_at"].toString(),
        id: json["id"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
      };
}
