// To parse this JSON data, do
//
//     final salesDataResponseModel = salesDataResponseModelFromJson(jsonString);

import 'dart:convert';

SalesDataResponseModel salesDataResponseModelFromJson(String str) =>
    SalesDataResponseModel.fromJson(json.decode(str));

class SalesDataResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  SalesDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory SalesDataResponseModel.fromJson(Map<String, dynamic> json) =>
      SalesDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final String? totalSaleAmount;
  final String? totalSaleCount;

  Data({
    this.totalSaleAmount,
    this.totalSaleCount,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        totalSaleAmount: json["total_sale_amount"] != null
            ? json["total_sale_amount"].toString()
            : "",
        totalSaleCount: json["total_sale_count"] != null
            ? json["total_sale_count"].toString()
            : "",
      );
}
