// To parse this JSON data, do
//
//     final recentTransactionResponseModel = recentTransactionResponseModelFromJson(jsonString);

import 'dart:convert';

RecentTransactionResponseModel recentTransactionResponseModelFromJson(
        String str) =>
    RecentTransactionResponseModel.fromJson(json.decode(str));

class RecentTransactionResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  RecentTransactionResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory RecentTransactionResponseModel.fromJson(Map<String, dynamic> json) =>
      RecentTransactionResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final List<RecentTransaction>? data;

  Data({
    this.data,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        data: json["data"] == null
            ? []
            : List<RecentTransaction>.from(
                json["data"]!.map((x) => RecentTransaction.fromJson(x))),
      );
}

class RecentTransaction {
  final int? id;
  final String? invoiceNumber;
  final dynamic referenceNumber;
  final String? purchaseDate;
  final String? supplierId;
  final String? warehouseId;
  final String? discountType;
  final String? discountValue;
  final String? discountAmount;
  final String? shippingAmount;
  final String? subtotal;
  final String? total;
  final dynamic attachment;
  final String? status;
  final String? adminId;
  final dynamic deletedAt;
  final String? createdAt;
  final String? updatedAt;
  bool isLoading;

  RecentTransaction(
      {this.id,
      this.invoiceNumber,
      this.referenceNumber,
      this.purchaseDate,
      this.supplierId,
      this.warehouseId,
      this.discountType,
      this.discountValue,
      this.discountAmount,
      this.shippingAmount,
      this.subtotal,
      this.total,
      this.attachment,
      this.status,
      this.adminId,
      this.deletedAt,
      this.createdAt,
      this.updatedAt,
      this.isLoading = false});

  factory RecentTransaction.fromJson(Map<String, dynamic> json) =>
      RecentTransaction(
        id: json["id"],
        invoiceNumber: json["invoice_number"] != null
            ? json["invoice_number"].toString()
            : "",
        referenceNumber: json["reference_number"] != null
            ? json["reference_number"].toString()
            : "",
        purchaseDate: json["purchase_date"] != null
            ? json["purchase_date"].toString()
            : "",
        supplierId:
            json["supplier_id"] != null ? json["supplier_id"].toString() : "",
        warehouseId:
            json["warehouse_id"] != null ? json["warehouse_id"].toString() : "",
        discountType: json["discount_type"] != null
            ? json["discount_type"].toString()
            : "",
        discountValue: json["discount_value"] != null
            ? json["discount_value"].toString()
            : "",
        discountAmount: json["discount_amount"] != null
            ? json["discount_amount"].toString()
            : "",
        shippingAmount: json["shipping_amount"] != null
            ? json["shipping_amount"].toString()
            : "",
        subtotal: json["subtotal"] != null ? json["subtotal"].toString() : "",
        total: json["total"] != null ? json["total"].toString() : "",
        attachment:
            json["attachment"] != null ? json["attachment"].toString() : "",
        status: json["status"] != null ? json["status"].toString() : "",
        adminId: json["admin_id"] != null ? json["admin_id"].toString() : "",
        deletedAt: json["deleted_at"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );
}
