// To parse this JSON data, do
//
//     final dashboardResponseModel = dashboardResponseModelFromJson(jsonString);

import 'dart:convert';

DashboardResponseModel dashboardResponseModelFromJson(String str) =>
    DashboardResponseModel.fromJson(json.decode(str));

String dashboardResponseModelToJson(DashboardResponseModel data) =>
    json.encode(data.toJson());

class DashboardResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  DashboardResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory DashboardResponseModel.fromJson(Map<String, dynamic> json) =>
      DashboardResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Graph? graph;
  final User? user;

  Data({
    this.graph,
    this.user,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        graph: json["graph"] == null ? null : Graph.fromJson(json["graph"]),
        user: json["user"] == null ? null : User.fromJson(json["user"]),
      );

  Map<String, dynamic> toJson() => {
        "graph": graph?.toJson(),
        "user": user?.toJson(),
      };
}

class Graph {
  final List<String>? dates;
  final List<String>? sales;
  final List<String>? purchase;

  Graph({
    this.dates,
    this.sales,
    this.purchase,
  });

  factory Graph.fromJson(Map<String, dynamic> json) => Graph(
        dates: json["dates"] == null
            ? []
            : List<String>.from(json["dates"]!.map((x) => x)),
        sales: json["sales"] == null
            ? []
            : List<String>.from(json["sales"]!.map((x) => x?.toString())),
        purchase: json["purchase"] == null
            ? []
            : List<String>.from(json["purchase"]!.map((x) => x.toString())),
      );

  Map<String, dynamic> toJson() => {
        "dates": dates == null ? [] : List<dynamic>.from(dates!.map((x) => x)),
        "sales": sales == null ? [] : List<dynamic>.from(sales!.map((x) => x)),
        "purchase":
            purchase == null ? [] : List<dynamic>.from(purchase!.map((x) => x)),
      };
}

class User {
  final String? id;
  final String? firstname;
  final String? lastname;
  final String? username;
  final String? email;
  final String? dialCode;
  final String? imageSrc;
  final String? mobile;
  final String? refBy;
  final String? countryName;
  final String? countryCode;
  final String? city;
  final String? state;
  final String? zip;
  final String? address;
  final String? status;
  final String? kycRejectionReason;
  final String? kv;
  final String? ev;
  final String? sv;
  final String? profileComplete;
  final String? verCodeSendAt;
  final String? ts;
  final String? tv;
  final String? tsc;
  final String? parentId;
  final String? isStaff;
  final String? banReason;
  final String? provider;
  final String? providerId;
  final String? planId;
  final String? planExpiredAt;
  final String? productLimit;
  final String? userLimit;
  final String? warehouseLimit;
  final String? supplierLimit;
  final String? hrmAccess;
  final String? couponLimit;
  final String? isDeleted;
  final String? createdAt;
  final String? updatedAt;
  final User? parent;

  User({
    this.id,
    this.firstname,
    this.imageSrc,
    this.lastname,
    this.username,
    this.email,
    this.dialCode,
    this.mobile,
    this.refBy,
    this.countryName,
    this.countryCode,
    this.city,
    this.state,
    this.zip,
    this.address,
    this.status,
    this.kycRejectionReason,
    this.kv,
    this.ev,
    this.sv,
    this.profileComplete,
    this.verCodeSendAt,
    this.ts,
    this.tv,
    this.tsc,
    this.parentId,
    this.isStaff,
    this.banReason,
    this.provider,
    this.providerId,
    this.planId,
    this.planExpiredAt,
    this.productLimit,
    this.userLimit,
    this.warehouseLimit,
    this.supplierLimit,
    this.hrmAccess,
    this.couponLimit,
    this.isDeleted,
    this.createdAt,
    this.updatedAt,
    this.parent,
  });

  factory User.fromJson(Map<String, dynamic> json) => User(
        id: json["id"]?.toString(),
        firstname: json["firstname"]?.toString(),
        lastname: json["lastname"]?.toString(),
        username: json["username"]?.toString(),
        imageSrc: json["image_src"]?.toString(),
        email: json["email"]?.toString(),
        dialCode: json["dial_code"]?.toString(),
        mobile: json["mobile"]?.toString(),
        refBy: json["ref_by"]?.toString(),
        countryName: json["country_name"]?.toString(),
        countryCode: json["country_code"]?.toString(),
        city: json["city"]?.toString(),
        state: json["state"]?.toString(),
        zip: json["zip"]?.toString(),
        address: json["address"]?.toString(),
        status: json["status"]?.toString(),
        kycRejectionReason: json["kyc_rejection_reason"]?.toString(),
        kv: json["kv"]?.toString(),
        ev: json["ev"]?.toString(),
        sv: json["sv"]?.toString(),
        profileComplete: json["profile_complete"]?.toString(),
        verCodeSendAt: json["ver_code_send_at"]?.toString(),
        ts: json["ts"]?.toString(),
        tv: json["tv"]?.toString(),
        tsc: json["tsc"]?.toString(),
        parentId: json["parent_id"]?.toString(),
        isStaff: json["is_staff"]?.toString(),
        banReason: json["ban_reason"]?.toString(),
        provider: json["provider"]?.toString(),
        providerId: json["provider_id"]?.toString(),
        planId: json["plan_id"]?.toString(),
        planExpiredAt: json["plan_expired_at"]?.toString(),
        productLimit: json["product_limit"]?.toString(),
        userLimit: json["user_limit"]?.toString(),
        warehouseLimit: json["warehouse_limit"]?.toString(),
        supplierLimit: json["supplier_limit"]?.toString(),
        hrmAccess: json["hrm_access"]?.toString(),
        couponLimit: json["coupon_limit"]?.toString(),
        isDeleted: json["is_deleted"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        parent: json["parent"] == null ? null : User.fromJson(json["parent"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "firstname": firstname,
        "lastname": lastname,
        "username": username,
        "email": email,
        "dial_code": dialCode,
        "image_src": imageSrc,
        "mobile": mobile,
        "ref_by": refBy,
        "country_name": countryName,
        "country_code": countryCode,
        "city": city,
        "state": state,
        "zip": zip,
        "address": address,
        "status": status,
        "kyc_rejection_reason": kycRejectionReason,
        "kv": kv,
        "ev": ev,
        "sv": sv,
        "profile_complete": profileComplete,
        "ver_code_send_at": verCodeSendAt,
        "ts": ts,
        "tv": tv,
        "tsc": tsc,
        "parent_id": parentId,
        "is_staff": isStaff,
        "ban_reason": banReason,
        "provider": provider,
        "provider_id": providerId,
        "plan_id": planId,
        "plan_expired_at": planExpiredAt,
        "product_limit": productLimit,
        "user_limit": userLimit,
        "warehouse_limit": warehouseLimit,
        "supplier_limit": supplierLimit,
        "hrm_access": hrmAccess,
        "coupon_limit": couponLimit,
        "is_deleted": isDeleted,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "parent": parent?.toJson(),
      };
}
