// To parse this JSON data, do
//
//     final customerUpdateResponseModel = customerUpdateResponseModelFromJson(jsonString);

import 'dart:convert';

CustomerUpdateResponseModel customerUpdateResponseModelFromJson(String str) =>
    CustomerUpdateResponseModel.fromJson(json.decode(str));

String customerUpdateResponseModelToJson(CustomerUpdateResponseModel data) =>
    json.encode(data.toJson());

class CustomerUpdateResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  CustomerUpdateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CustomerUpdateResponseModel.fromJson(Map<String, dynamic> json) =>
      CustomerUpdateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Customer? customer;

  Data({
    this.customer,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        customer: json["customer"] == null
            ? null
            : Customer.fromJson(json["customer"]),
      );

  Map<String, dynamic> toJson() => {
        "customer": customer?.toJson(),
      };
}

class Customer {
  String? id;
  String? name;
  String? email;
  String? mobile;
  String? address;
  String? city;
  String? state;
  String? country;
  String? zip;
  String? postcode;
  String? status;
  String? deletedAt;
  String? createdAt;
  String? updatedAt;

  Customer({
    this.id,
    this.name,
    this.email,
    this.mobile,
    this.address,
    this.city,
    this.state,
    this.country,
    this.zip,
    this.postcode,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Customer.fromJson(Map<String, dynamic> json) => Customer(
        id: json["id"].toString(),
        name: json["name"].toString(),
        email: json["email"].toString(),
        mobile: json["mobile"].toString(),
        address: json["address"].toString(),
        city: json["city"].toString(),
        state: json["state"].toString(),
        country: json["country"].toString(),
        zip: json["zip"].toString(),
        postcode: json["postcode"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "email": email,
        "mobile": mobile,
        "address": address,
        "city": city,
        "state": state,
        "country": country,
        "zip": zip,
        "postcode": postcode,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
