// To parse this JSON data, do
//
//     final couponUpdateResponseModel = couponUpdateResponseModelFromJson(jsonString);

import 'dart:convert';

import 'add_new_coupon_response_model.dart';

CouponUpdateResponseModel couponUpdateResponseModelFromJson(String str) =>
    CouponUpdateResponseModel.fromJson(json.decode(str));

String couponUpdateResponseModelToJson(CouponUpdateResponseModel data) =>
    json.encode(data.toJson());

class CouponUpdateResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  CouponUpdateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CouponUpdateResponseModel.fromJson(Map<String, dynamic> json) =>
      CouponUpdateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Coupon? coupon;

  Data({
    this.coupon,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        coupon: json["coupon"] == null ? null : Coupon.fromJson(json["coupon"]),
      );

  Map<String, dynamic> toJson() => {
        "coupon": coupon?.toJson(),
      };
}
