// To parse this JSON data, do
//
//     final couponSuccessResponseModel = couponSuccessResponseModelFromJson(jsonString);

import 'dart:convert';

CouponSuccessResponseModel couponSuccessResponseModelFromJson(String str) =>
    CouponSuccessResponseModel.fromJson(json.decode(str));

class CouponSuccessResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  CouponSuccessResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CouponSuccessResponseModel.fromJson(Map<String, dynamic> json) =>
      CouponSuccessResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final String? discountType;
  final String? amount;
  final String? couponId;

  Data({
    this.discountType,
    this.amount,
    this.couponId,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        discountType: json["discount_type"] != null
            ? json["discount_type"].toString()
            : '',
        amount: json["amount"] != null ? json["amount"].toString() : '',
        couponId: json["coupon_id"] != null ? json["coupon_id"].toString() : '',
      );
}
