// To parse this JSON data, do
//
//     final couponStatusChangeResponseModel = couponStatusChangeResponseModelFromJson(jsonString);

import 'dart:convert';

CouponStatusChangeResponseModel couponStatusChangeResponseModelFromJson(
        String str) =>
    CouponStatusChangeResponseModel.fromJson(json.decode(str));

String couponStatusChangeResponseModelToJson(
        CouponStatusChangeResponseModel data) =>
    json.encode(data.toJson());

class CouponStatusChangeResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  CouponStatusChangeResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CouponStatusChangeResponseModel.fromJson(Map<String, dynamic> json) =>
      CouponStatusChangeResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Coupon? coupon;

  Data({
    this.coupon,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        coupon: json["coupon"] == null ? null : Coupon.fromJson(json["coupon"]),
      );

  Map<String, dynamic> toJson() => {
        "coupon": coupon?.toJson(),
      };
}

class Coupon {
  final String? id;
  final String? name;
  final String? code;
  final String? startFrom;
  final String? endAt;
  final String? minimumAmount;
  final String? discountType;
  final String? amount;
  final String? maximumUsingTime;
  final String? description;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  Coupon({
    this.id,
    this.name,
    this.code,
    this.startFrom,
    this.endAt,
    this.minimumAmount,
    this.discountType,
    this.amount,
    this.maximumUsingTime,
    this.description,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory Coupon.fromJson(Map<String, dynamic> json) => Coupon(
        id: json["id"].toString(),
        name: json["name"].toString(),
        code: json["code"].toString(),
        startFrom: json["start_from"].toString(),
        endAt: json["end_at"].toString(),
        minimumAmount: json["minimum_amount"].toString(),
        discountType: json["discount_type"].toString(),
        amount: json["amount"].toString(),
        maximumUsingTime: json["maximum_using_time"].toString(),
        description: json["description"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "code": code,
        "start_from": startFrom,
        "end_at": endAt,
        "minimum_amount": minimumAmount,
        "discount_type": discountType,
        "amount": amount,
        "maximum_using_time": maximumUsingTime,
        "description": description,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
