// To parse this JSON data, do
//
//     final couponResponseModel = couponResponseModelFromJson(jsonString);

import 'dart:convert';

CouponResponseModel couponResponseModelFromJson(String str) =>
    CouponResponseModel.fromJson(json.decode(str));

class CouponResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  CouponResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CouponResponseModel.fromJson(Map<String, dynamic> json) =>
      CouponResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final List<Coupon>? coupons;

  Data({
    this.coupons,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        coupons: json["coupons"] == null
            ? []
            : List<Coupon>.from(
                json["coupons"]!.map((x) => Coupon.fromJson(x))),
      );
}

class Coupon {
  final String? id;
  final String? name;
  final String? code;
  final String? startFrom;
  final String? endAt;
  final String? minimumAmount;
  final String? discountType;
  final String? amount;
  final String? maximumUsingTime;
  final String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  bool isLoading;

  Coupon(
      {this.id,
      this.name,
      this.code,
      this.startFrom,
      this.endAt,
      this.minimumAmount,
      this.discountType,
      this.amount,
      this.maximumUsingTime,
      this.status,
      this.deletedAt,
      this.createdAt,
      this.updatedAt,
      this.isLoading = false});

  factory Coupon.fromJson(Map<String, dynamic> json) => Coupon(
        id: json["id"].toString(),
        name: json["name"].toString(),
        code: json["code"] != null ? json["code"].toString() : "",
        startFrom: json["start_from"].toString(),
        endAt: json["end_at"].toString(),
        minimumAmount: json["minimum_amount"].toString(),
        discountType: json["discount_type"] != null
            ? json["discount_type"].toString()
            : "",
        amount: json["amount"].toString(),
        maximumUsingTime: json["maximum_using_time"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );
}
