// To parse this JSON data, do
//
//     final couponListResponseModel = couponListResponseModelFromJson(jsonString);

import 'dart:convert';

CouponListResponseModel couponListResponseModelFromJson(String str) =>
    CouponListResponseModel.fromJson(json.decode(str));

String couponListResponseModelToJson(CouponListResponseModel data) =>
    json.encode(data.toJson());

class CouponListResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  CouponListResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CouponListResponseModel.fromJson(Map<String, dynamic> json) =>
      CouponListResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Coupons? coupons;

  Data({
    this.coupons,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        coupons:
            json["coupons"] == null ? null : Coupons.fromJson(json["coupons"]),
      );

  Map<String, dynamic> toJson() => {
        "coupons": coupons?.toJson(),
      };
}

class Coupons {
  final String? currentPage;
  final List<CouponListData>? data;
  final String? firstPageUrl;
  final String? from;
  final String? lastPage;
  final String? lastPageUrl;
  final List<Link>? links;
  final String? nextPageUrl;
  final String? path;
  final String? perPage;
  final String? prevPageUrl;
  final String? to;
  final String? total;

  Coupons({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.links,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory Coupons.fromJson(Map<String, dynamic> json) => Coupons(
        currentPage: json["current_page"].toString(),
        data: json["data"] == null
            ? []
            : List<CouponListData>.from(
                json["data"]!.map((x) => CouponListData.fromJson(x))),
        firstPageUrl: json["first_page_url"].toString(),
        from: json["from"].toString(),
        lastPage: json["last_page"].toString(),
        lastPageUrl: json["last_page_url"].toString(),
        links: json["links"] == null
            ? []
            : List<Link>.from(json["links"]!.map((x) => Link.fromJson(x))),
        nextPageUrl: json["next_page_url"].toString(),
        path: json["path"].toString(),
        perPage: json["per_page"].toString(),
        prevPageUrl: json["prev_page_url"].toString(),
        to: json["to"].toString(),
        total: json["total"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "links": links == null
            ? []
            : List<dynamic>.from(links!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class CouponListData {
  String? id;
  final String? name;
  final String? code;
  final String? startFrom;
  final String? endAt;
  final String? minimumAmount;
  final String? discountType;
  final String? amount;
  final String? maximumUsingTime;
  final String? description;
  String? status;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;

  CouponListData({
    this.id,
    this.name,
    this.code,
    this.startFrom,
    this.endAt,
    this.minimumAmount,
    this.discountType,
    this.amount,
    this.maximumUsingTime,
    this.description,
    this.status,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
  });

  factory CouponListData.fromJson(Map<String, dynamic> json) => CouponListData(
        id: json["id"].toString(),
        name: json["name"].toString(),
        code: json["code"].toString(),
        startFrom: json["start_from"].toString(),
        endAt: json["end_at"].toString(),
        minimumAmount: json["minimum_amount"].toString(),
        discountType: json["discount_type"].toString(),
        amount: json["amount"].toString(),
        maximumUsingTime: json["maximum_using_time"].toString(),
        description: json["description"].toString(),
        status: json["status"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "code": code,
        "start_from": startFrom,
        "end_at": endAt,
        "minimum_amount": minimumAmount,
        "discount_type": discountType,
        "amount": amount,
        "maximum_using_time": maximumUsingTime,
        "description": description,
        "status": status,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Link {
  final String? url;
  final String? label;
  final bool? active;

  Link({
    this.url,
    this.label,
    this.active,
  });

  factory Link.fromJson(Map<String, dynamic> json) => Link(
        url: json["url"].toString(),
        label: json["label"].toString(),
        active: json["active"],
      );

  Map<String, dynamic> toJson() => {
        "url": url,
        "label": label,
        "active": active,
      };
}
