// To parse this JSON data, do
//
//     final addNewCouponResponseModel = addNewCouponResponseModelFromJson(jsonString);

import 'dart:convert';

AddNewCouponResponseModel addNewCouponResponseModelFromJson(String str) =>
    AddNewCouponResponseModel.fromJson(json.decode(str));

String addNewCouponResponseModelToJson(AddNewCouponResponseModel data) =>
    json.encode(data.toJson());

class AddNewCouponResponseModel {
  String? remark;
  String? status;
  List<String>? message;
  Data? data;

  AddNewCouponResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory AddNewCouponResponseModel.fromJson(Map<String, dynamic> json) =>
      AddNewCouponResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  Coupon? coupon;

  Data({
    this.coupon,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        coupon: json["coupon"] == null ? null : Coupon.fromJson(json["coupon"]),
      );

  Map<String, dynamic> toJson() => {
        "coupon": coupon?.toJson(),
      };
}

class Coupon {
  String? name;
  String? code;
  String? startFrom;
  String? endAt;
  String? minimumAmount;
  String? discountType;
  String? amount;
  String? description;
  String? maximumUsingTime;
  String? updatedAt;
  String? createdAt;
  String? id;

  Coupon({
    this.name,
    this.code,
    this.startFrom,
    this.endAt,
    this.minimumAmount,
    this.discountType,
    this.amount,
    this.description,
    this.maximumUsingTime,
    this.updatedAt,
    this.createdAt,
    this.id,
  });

  factory Coupon.fromJson(Map<String, dynamic> json) => Coupon(
        name: json["name"].toString(),
        code: json["code"].toString(),
        startFrom: json["start_from"].toString(),
        endAt: json["end_at"].toString(),
        minimumAmount: json["minimum_amount"].toString(),
        discountType: json["discount_type"].toString(),
        amount: json["amount"].toString(),
        description: json["description"].toString(),
        maximumUsingTime: json["maximum_using_time"].toString(),
        updatedAt: json["updated_at"].toString(),
        createdAt: json["created_at"].toString(),
        id: json["id"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "code": code,
        "start_from": startFrom,
        "end_at": endAt,
        "minimum_amount": minimumAmount,
        "discount_type": discountType,
        "amount": amount,
        "description": description,
        "maximum_using_time": maximumUsingTime,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
      };
}
