// To parse this JSON data, do
//
//     final checkoutCartResponseModel = checkoutCartResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:ovosale/data/model/new_sale/new_sale_response_model.dart';

CheckoutCartResponseModel checkoutCartResponseModelFromJson(String str) =>
    CheckoutCartResponseModel.fromJson(json.decode(str));

class CheckoutCartResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  CheckoutCartResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CheckoutCartResponseModel.fromJson(Map<String, dynamic> json) =>
      CheckoutCartResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final List<SaleProduct>? products;

  Data({
    this.products,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        products: json["products"] == null
            ? []
            : List<SaleProduct>.from(
                json["products"]!.map((x) => SaleProduct.fromJson(x))),
      );
}
