// To parse this JSON data, do
//
//     final updateProductResponseModel = updateProductResponseModelFromJson(jsonString);

import 'dart:convert';

UpdateCategoryResponseModel updateCategoryResponseModelFromJson(String str) =>
    UpdateCategoryResponseModel.fromJson(json.decode(str));

String updateProductResponseModelToJson(UpdateCategoryResponseModel data) =>
    json.encode(data.toJson());

class UpdateCategoryResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  UpdateCategoryResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory UpdateCategoryResponseModel.fromJson(Map<String, dynamic> json) =>
      UpdateCategoryResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Category? category;

  Data({
    this.category,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        category: json["category"] == null
            ? null
            : Category.fromJson(json["category"]),
      );

  Map<String, dynamic> toJson() => {
        "category": category?.toJson(),
      };
}

class Category {
  final String? name;
  final String? updatedAt;
  final String? createdAt;
  final String? id;
  final String? imageSrc;

  Category({
    this.name,
    this.updatedAt,
    this.createdAt,
    this.id,
    this.imageSrc,
  });

  factory Category.fromJson(Map<String, dynamic> json) => Category(
        name: json["name"].toString(),
        updatedAt: json["updated_at"].toString(),
        createdAt: json["created_at"].toString(),
        id: json["id"].toString(),
        imageSrc: json["image_src"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
        "image_src": imageSrc,
      };
}
