// To parse this JSON data, do
//
//     final categoryStatusDataResponseModel = categoryStatusDataResponseModelFromJson(jsonString);

import 'dart:convert';

CategoryStatusDataResponseModel categoryStatusDataResponseModelFromJson(
        String str) =>
    CategoryStatusDataResponseModel.fromJson(json.decode(str));

String categoryStatusDataResponseModelToJson(
        CategoryStatusDataResponseModel data) =>
    json.encode(data.toJson());

class CategoryStatusDataResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  CategoryStatusDataResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CategoryStatusDataResponseModel.fromJson(Map<String, dynamic> json) =>
      CategoryStatusDataResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message":
            message == null ? [] : List<dynamic>.from(message!.map((x) => x)),
        "data": data?.toJson(),
      };
}

class Data {
  final Category? category;

  Data({
    this.category,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        category: json["category"] == null
            ? null
            : Category.fromJson(json["category"]),
      );

  Map<String, dynamic> toJson() => {
        "category": category?.toJson(),
      };
}

class Category {
  final String? id;
  final String? name;
  final String? status;
  final String? image;
  final String? deletedAt;
  final String? createdAt;
  final String? updatedAt;
  final String? imageSrc;

  Category({
    this.id,
    this.name,
    this.status,
    this.image,
    this.deletedAt,
    this.createdAt,
    this.updatedAt,
    this.imageSrc,
  });

  factory Category.fromJson(Map<String, dynamic> json) => Category(
        id: json["id"].toString(),
        name: json["name"].toString(),
        status: json["status"].toString(),
        image: json["image"].toString(),
        deletedAt: json["deleted_at"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        imageSrc: json["image_src"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "image": image,
        "deleted_at": deletedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "image_src": imageSrc,
      };
}
