// To parse this JSON data, do
//
//     final cartCountResponseModel = cartCountResponseModelFromJson(jsonString);

import 'dart:convert';

CartCountResponseModel cartCountResponseModelFromJson(String str) =>
    CartCountResponseModel.fromJson(json.decode(str));

class CartCountResponseModel {
  final String? remark;
  final String? status;
  final List<String>? message;
  final Data? data;

  CartCountResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory CartCountResponseModel.fromJson(Map<String, dynamic> json) =>
      CartCountResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null
            ? []
            : List<String>.from(json["message"]!.map((x) => x)),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  final String? cartCount;

  Data({
    this.cartCount,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        cartCount:
            json["cart_count"] != null ? json["cart_count"].toString() : "",
      );
}
